#version 430


in vec2 uv;

layout(location = 0) out vec4 frag;

uniform float g_time;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


layout(binding=0) uniform sampler2D texA;
layout(binding=1) uniform sampler2D texB;
layout(binding=2) uniform sampler2D texMask;

uniform float g_currentAmount = 1.0;
uniform float g_prevAmount = 1.0;

uniform float g_darkenAmp = 0.0;
uniform float g_darkenPow = 1.0;

uniform float effectWidth = 1280.0;
uniform float effectHeight = 720.0;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;

void main() {


    vec4 screen = texelFetch(texA, ivec2(gl_FragCoord.xy), 0);

    //screen.xy *= 0.0005;

    if (screen.x < 0.5 && screen.y < 0.5) {
        frag = vec4(0.0);
        return;
    }

    vec4 orig = texelFetch(texB, ivec2(gl_FragCoord.xy), 0);

    screen.xy -= gl_FragCoord.xy;

 //   screen.xy /= vec2(g_windowWidth, g_windowHeight);

    screen.x /= g_windowWidth;
    screen.y /= g_windowWidth;

    float dist = sqrt(dot(screen.xy, screen.xy));

    // dist = pow(dist, 0.50);

    if (orig.r > 0.5) {
        dist *= -1.0;
    }

    screen.rgb = vec3(dist);

    frag = screen;
}
