#version 430


in vec2 uv;

layout(location = 0) out vec4 frag;

uniform float g_time;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


layout(binding=0) uniform sampler2D tex;

uniform float g_currentAmount = 1.0;
uniform float g_prevAmount = 1.0;

uniform float g_darkenAmp = 0.0;
uniform float g_darkenPow = 1.0;

uniform float effectWidth = 1280.0;
uniform float effectHeight = 720.0;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;

uniform float searchDist = 1.0;

void main() {


    vec4 res = vec4(0.0);

    float smallestDist = 1000000.0;
    // ivec2 smallestCoord =
    for (int y=-1; y<=1; y++) {
        for (int x=-1; x<=1; x++) {
            vec2 mc = gl_FragCoord.xy;
            ivec2 sc = ivec2(gl_FragCoord.xy)+ivec2(x*searchDist,y*searchDist);
            sc = clamp(sc, ivec2(0), ivec2(g_windowWidth-1.0, g_windowHeight-1.0));
            vec4 c = texelFetch(tex, sc, 0);
            if (c.x > 0.5 && c.y > 0.5) {
                vec2 delta = c.xy-mc;
                float d = dot(delta, delta);
                if (d < smallestDist) {
                    res.xy = c.xy;
                    smallestDist = d;
                }
            }
        }
    }

    frag = res;
}
