#version 430


in vec2 uv;

layout(location = 0) out vec4 frag;

uniform float g_time;

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


layout(binding=0) uniform sampler2D tex;

uniform float g_currentAmount = 1.0;
uniform float g_prevAmount = 1.0;

uniform float g_darkenAmp = 0.0;
uniform float g_darkenPow = 1.0;

uniform float effectWidth = 1280.0;
uniform float effectHeight = 720.0;

uniform float g_windowWidth = 1280.0;
uniform float g_windowHeight = 720.0;

uniform float inFull = 0.0;

void main() {

    frag = vec4(0.0);


    if (inFull > 0.5) {
        vec4 screen = texelFetch(tex, ivec2(gl_FragCoord.xy+ivec2(-1, 0)), 0);
        if (screen.r > 0.5) {
            frag.xy = gl_FragCoord.xy;
        }
        return;
    }


    vec4 dx = texelFetch(tex, ivec2(gl_FragCoord.xy+ivec2(1, 0)), 0)-texelFetch(tex, ivec2(gl_FragCoord.xy+ivec2(-1, 0)), 0);
    vec4 dy = texelFetch(tex, ivec2(gl_FragCoord.xy+ivec2(0, 1)), 0)-texelFetch(tex, ivec2(gl_FragCoord.xy+ivec2(0, -1)), 0);
    if ((abs(dx.x)>0.5) || (abs(dy.x)>0.5)) {
        frag.xy = gl_FragCoord.xy;
    }

    // frag.xy = gl_FragCoord.xy*0.001;

  //  frag = vec4(0.0, 0.0, 1.0, 1.0);
    //frag = (1.0-alf)*screenA+screenB;
    //frag = screenB;
}
