#version 430

layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;

in vec3 normal[3];
in vec2 uv[3];
in vec3 tangent[3];
in vec4 origPos[3];

out vec4 posG;
out vec4 posSG;
out vec4 prevPosG;
out vec4 prevPosSG;
out vec3 normalG;
out vec3 normalWSG;
out vec3 velG;
out vec2 uvG;
out vec3 tangentG;
out vec3 colorG;
out vec4 posW;
out vec3 randG;
out vec4 posWM;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 viewMatrix;
uniform mat4 modelMatrix;
uniform mat4 prevModelMatrix;
uniform mat4 prevViewMatrix;

uniform float g_time;

uniform float windowWidth;
uniform float windowHeight;

layout(binding=0) uniform sampler2D tex;
layout(binding=1) uniform sampler2D texNorm;
layout(binding=2) uniform sampler2D texEnv;
layout(binding=3) uniform sampler2D texPrevFrame;
layout(binding=4) uniform sampler2D texDepth;

//layout(binding=0, offset=0) uniform atomic_uint ac;
//layout(binding=0, rgba32f) uniform image2D voxPosComp;
//layout(binding=1, rgba32f) uniform image2D voxNorComp;

uniform float g_instLayer = 0.0;

uniform float g_voxelAreaSize;

uniform float zNear = 0.1;
uniform float zFar = 1000.0;
// convert from 0.0 to 1.0 depth sample ds to linear depth
float linearDepth(float ds) {
    ds = 2.0*ds-1.0;
    float zLinear = 2.0*zNear*zFar/(zFar+zNear-ds*(zFar-zNear));
    return zLinear;
}

float atanSafe(float y, float x) {
 float ret=0.0;
        if (x!=0.0) {
                if (x>0.0) {
                        ret=atan(y/x);
                } else	{
                        ret=atan(y/x)+3.141592;
                }
        } else {
                if (y>=0.0) {
                        ret=0.5*3.141592;
                } else {
                        ret=-0.5*3.141592;
                }
        }
 return ret;
}

vec3 rotAroundAxis(vec3 vec, vec3 axis, float alpha) {
  float ca = cos(alpha);
  float sa = sin(alpha);
  float u = axis.x;
  float v = axis.y;
  float w = axis.z;
  vec3 rot;
  rot.x = u*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.x*ca+(-w*vec.y+v*vec.z)*sa;
  rot.y = v*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.y*ca+(w*vec.x-u*vec.z)*sa;
  rot.z = w*(u*vec.x+v*vec.y+w*vec.z)*(1.0-ca)+vec.z*ca+(-v*vec.x+u*vec.y)*sa;
  return rot;
}

vec3 cross(vec3 a, vec3 b) {
  vec3 r;
  r.x = a.y*b.z - a.z*b.y;
  r.y = a.z*b.x - a.x*b.z;
  r.z = a.x*b.y - a.y*b.x;
  return r;
}

// google glsl rand gave this, thanks and credit flies to
// http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}



uniform vec4 g_pos; // model matrix contains instanced model transform so this overall pos comes separated

uniform float g_flipNormal = 1.0;

void main(void) {

        vec3 controlBase = vec3(0.0);


        vec4 posWW;

        vec4 prevPosModel;

        float flipNormal = 1.0;
        if (g_flipNormal > 0.5) {
          flipNormal = -1.0;
        }

        for (int i = 0; i < gl_in.length(); ++i) {
                gl_Position = gl_in[i].gl_Position;
                posW = gl_Position;

                prevPosG = prevModelMatrix*gl_Position;
                prevPosModel = prevPosG;
               prevPosSG = prevViewMatrix*prevPosG;
               prevPosSG = projectionMatrix*prevPosSG;

                gl_Position = modelMatrix*gl_Position;
                normalG = flipNormal*normal[i];
                normalG = normalize((modelMatrix*(vec4(normalG, 0.0))).xyz);


              //  posWM = modelMatrix*gl_Position;

                velG = (gl_Position-prevPosModel).xyz;

                posWW = gl_Position;
                //posMod = gl_Position;

                posWM = gl_Position;
                posG = gl_Position;

                gl_Position = viewMatrix*(gl_Position);

                colorG = vec3(1.0);

                float depu = 0.0;
                vec3 ssNormal = vec3(0.0);

                normalWSG = (vec4(normalG, 0.0)).xyz;
                normalG = (viewMatrix * vec4(normalG, 0.0)).xyz;

                gl_Position = projectionMatrix*gl_Position;
                posSG = gl_Position;

                uvG = uv[i];
                tangentG = tangent[i];

                EmitVertex();
        }

        EndPrimitive();

}
