#version 430


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(points) in;
layout(triangle_strip, max_vertices = 4) out;
//layout(max_vertices = 2) out;

//layout(line_strip, max_vertices = 15) out;

in vec3 posV[];
in vec2 uvV[];
in vec3 velV[];
in vec3 colV[];
in float ageV[];
in float recV[];

in vec4 paramsV[]; // .x = partikle unique random number

//in vec4 posInitV[];
// in vec4 posScrV[];

out vec4 posG;
out vec2 uvG;
out vec2 uvOrig;
out vec3 colG;
out float sharpnessG;
//out vec4 posSS;
out float age;
out vec3 ageColG;
out float brightG;
out float aspectG;
out vec3 posW;


uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform mat4 modelMatrix;

uniform float g_time;

uniform float g_triangleTexDim;

layout(binding=0) uniform sampler2D tex;

layout(binding=0, offset=0) uniform atomic_uint ac;


uniform float g_texW;
uniform float g_texH;

//particleGridCounts
//particleGridHeadPointers
//particleIds

layout(binding=0, r32i) uniform iimage2D particleGridCounts; // read
layout(binding=1, r32i) uniform iimage2D particleGridOfs; // read
layout(binding=2, r32i) uniform iimage2D particleGridWriteOfs; // read & write
layout(binding=3, rgba32f) uniform image2D particleArrPos; // write
layout(binding=4, rgba32f) uniform image2D particleArrVel; // write

uniform float g_hpTexBaseDim = 8.0;
uniform float g_gridCellSize = 1.0;

ivec2 pos3DToTex2D(vec3 p3d) {
    float gridW = g_hpTexBaseDim*g_hpTexBaseDim;
    vec3 cell = (fract(p3d/(g_gridCellSize*gridW)+vec3(0.5)));
    cell = floor(cell*gridW);
    float cellzy = floor(cell.z/g_hpTexBaseDim);
    float cellzx = cell.z-cellzy*g_hpTexBaseDim;
    ivec2 cellUV = ivec2(cell.x+cellzx*gridW, cell.y+cellzy*gridW);
    return cellUV;
}

ivec2 uint3DToTex2D(uint i) {
    uint gridW = uint(g_hpTexBaseDim*g_hpTexBaseDim);
    uint iz = i/(gridW*gridW);
    uint ixy = i-iz*gridW*gridW;
    uint iy = ixy/gridW;
    uint ix = ixy-iy*gridW;
    uint czy = (iz/uint(g_hpTexBaseDim));
    uint czx = iz-czy*uint(g_hpTexBaseDim);
    return ivec2(ix+czx*gridW, iy+czy*gridW);
}

ivec2 int2DToTex2D(int i) {
    ivec2 size = imageSize(particleArrPos);
    ivec2 res;
    res.y = i/size.x;
    res.x = i-res.y*size.x;
    return res;
}

void main(void) {
    uint partId = gl_PrimitiveIDIn;
    vec4 pos = vec4(posV[0], 1.0);
    vec4 pW = pos;
    ivec2 pp = pos3DToTex2D(pW.xyz);
    int curOfs = imageAtomicAdd(particleGridWriteOfs, pp, 1);
    int arrOfs = imageLoad(particleGridOfs, pp).x;
    ivec2 ppa = int2DToTex2D(arrOfs+curOfs);
    imageStore(particleArrPos, ppa, pW);
    imageStore(particleArrVel, ppa, vec4(velV[0], 0.0));
}
