class TransportMp3 {
  constructor (audioElement) {
    this._audio = audioElement
    this._audio.loop = false
    this._playHeadPosition = 0

    /*
    this._audio.addEventListener('canplay', (event) => console.log('canplay'))
    this._audio.addEventListener('canplaythrough', (event) => console.log('canplaythrough'))
    this._audio.addEventListener('stalled', (event) => console.log('stalled'))
    this._audio.addEventListener('waiting', (event) => console.log('waiting'))
    */
  }
  seekExact (time) {
    this._playHeadPosition = time
    this._audio.currentTime = time
  }
  seekDelta(time) {
    this._playHeadPosition = this._playHeadPosition + time
    this._audio.currentTime = this._playHeadPosition
  }
  update () {
    if (this.getIsPlaying()) {
      this._playHeadPosition = this._audio.currentTime
    }
  }
  getIsPlaying () {
    return !this._audio.paused
  }
  setIsPlaying(isPlaying) {
    if (isPlaying) {
      this._audio.play()
    } else {
      this._audio.pause()
    }
  }
  getCurrentTime () {
    return this._playHeadPosition
  }
}
