#version 330 core
layout (location = 0) in vec3 aPos;
layout (location = 1) in vec3 aColor;
layout (location = 2) in vec2 aTexCoord;

// to optimize ?? can comment out/delete out vec3 ourColor?, also in vec3 aColor? -> the position is used, but do we need anything else?
// ourColor = aColor, but what is ourColor used for in fragment shader?
out vec3 ourColor;
out vec2 TexCoord;

//uniform mat4 projection;
//uniform mat4 view;
//uniform mat4 model;
varying vec3 position;

void main()
{
	//gl_Position = projection * view * model * vec4(aPos.x, aPos.y, aPos.z, 1.0);
	gl_Position = vec4(aPos.x, aPos.y, aPos.z, 1.0);
	position = vec3(gl_Position.x, gl_Position.y, gl_Position.z);
	ourColor = aColor;
	TexCoord = vec2(aTexCoord.x, aTexCoord.y);
}
