#version 330 core

out vec4 FragColor;

in vec3 ourColor; // is this necessary?
in vec2 TexCoord;
varying vec3 position;
vec3 could_you = position;
uniform vec2 u_resolution;
uniform float u_time;
uniform sampler2D texture15; 
float time = u_time;
float b_time = time - 65.;
int MAX_STEPS = 100;
float MAX_DIST = 100.;
float SURF_DIST = .01;
float pi = 3.141592;
float sdCapsule(vec3 p, vec3 a, vec3 b, float r)
{

	vec3 ab = b - a;
	vec3 ap = p - a;
	
	float t = dot(ab, ap) / dot(ab, ab);
	t = clamp(t, 0., 1.);
	
	vec3 c = a + t * ab;
	
	return length(p - c) - r;

}

float sdTorus(vec3 p, vec2 r)
{

	float x = length(p.xz) - r.x;
	return length(vec2(x, p.y)) - r.y;

}

float dBox(vec3 p, vec3 s)
{

	//return length(abs(p) - s);
	return length(max(abs(p) - s, 0.));
}

float GetDist(vec3 p)
{
	//time = time - ? ;
	vec4 s = vec4(0, 1, 6, 1); // middle from left to right, 1 above ground plane, 6 away from us, radius 1 so it's touching the ground
	
	float sphereDist = length(p - s.xyz) - s.w;  // s.w is the fourth one, radius of the sphere
	float planeDist = p.y; // plane is a ground plane so just zero
	
	//float cd = sdCapsule(p, vec3(0, 1, 6), vec3(1, 2, 6), .2);
	//float td = sdTorus(p - vec3(0, .5, 6), vec2(1.5, .3));
	//float bd = dBox(p - vec3( -3, 1, 6), vec3( 1., 1., 1.));
	float bd = 0.;
	if (b_time < 10)
	{
		bd = dBox(p - vec3( p.x - ((-p.y * p.x) - (cos(p.y + sin(b_time)/p.y+p.x) + sin( 0.1 * p.z))),(((p.x +(sin((2. - p.y)  
		* (b_time * .01)))) * p.y) +(sin(-p.x * p.y))), -5 * ((p.y -.1) - (sin(b_time - p.x)))), 
		vec3( p.z - (sin(b_time - (.02 * p.z)) * p.y), (cos(b_time * .01) +.01 * -p.x), cos(p.x *.01) + ( (p.z +sin(b_time *.1)) * p.y )  ) );
	}
	
	if (b_time > 10)
	{
		bd = dBox(p - vec3( p.x - ((distance(p.x, p.y )) - (dot(p.y + sin(b_time), p.y/p.x) + sin( 0.1 * p.z))),(((p.x +(sin((2. - p.y) * (b_time * .01)))) * p.y) +(sin(-p.x * p.y))),
		-5 * ((p.y -.1) - (sin(b_time - p.x)))),
		vec3( p.z - (sin(b_time - (.02 * p.z)) * p.y), (cos(b_time * .01) +.01 * -p.x), cos(p.x *.01) + ( (p.z +sin(b_time *.1)) * p.y )  ));
	}
	
	float d = min(bd, planeDist); // float d = min(cd, planeDist); // total distance is the minimum of those distances
	//d = min(d, td);
	//d = min(d, bd);
	return d;
}

float RayMarch(vec3 ro, vec3 rd)
{

	float dO=0.;
	
	for( int i=0; i < MAX_STEPS; i++)
	{
		vec3 p = ro + rd * dO; // start in ray origin and march a certain distance in ray direction
		float dS = GetDist(p);
		dO += dS;
		if(dO > MAX_DIST || dS < SURF_DIST) break;
	}
	
	return dO;

}

vec3 GetNormal(vec3 p)
{
	float d = GetDist(p);
	vec2 e = vec2(.01, 0);
	vec3 n = vec3(0.);
	// e.xyy == vec3(.01, 0, 0) -- e.yxy == vec3(0, .01, 0) -- e.yyx == vec3(0, 0, .01) -- this is the derivative sampling around stuff (is it derivate?)
	if(b_time < 15){
		n = d - vec3(
		GetDist(p-e.xyy)*sin(time),
		GetDist(p-e.yxy)*cos(time),
		GetDist(p-e.yyx)*sin(time));
	}
	if (b_time > 15 && b_time < 36 ){
		n = d - vec3(
		GetDist(p-e.xyy)*2.,
		GetDist(p-e.yxy)*2.,
		GetDist(p-e.yyx)*2.);
	}
	if (b_time > 36){
		n = d - vec3(
		GetDist(p - e.xyy)*atan(b_time),
		GetDist(p - e.yxy)* .4,
		GetDist(p - e.xxy)* .7);
	}
	
	return normalize(n);
}

float GetLight(vec3 p)
{

	vec3 lightPos = vec3(0, 5, 6); // 5 above ground, 6 depth, above sphere
	lightPos.xz += vec2(sin(u_time), cos(u_time))*2.; 
	//lightPos.xyz += vec3(sin(u_time), cos(u_time), -5.); // for xyz 
	vec3 l = normalize(lightPos - p); // p surface pos
	
	vec3 n = GetNormal(p); // if needed use the one below and comment this out
	
	//vec3 n = (1.+GetNormal(p)) / 2; // here? seems to work?
	
	//float dif = dot(n, l); // [-1, 1] in the shade actually gets -1 so better use clamp because with more complicated materials would notice "crazy stuff"
	//->
	float dif = clamp(dot(n, l), 0., 1.);
	
	// Another suggestion from the comments: 
	//float dif = dot(n, l);
	//dif *= (1. + dif ) / 2;
	
	// shadows

	// for moving up from the plane first, then shadows:
	float d = RayMarch(p+n*SURF_DIST*2., l); // *2. is to increase distance until fixed

	// for kicking in raymarch loop - "too close" 
	//float d = RayMarch(p, l); // raymarch from point p into the direction of light
	
	if(d < length(lightPos - p)) dif *= .1; // if value < (distance between light and surface position) then i know i am in the shadow, can set to 0, or multiply with 10%.
	
	
	return dif;
}


void main()
{
	// Flopine way:
	//vec2 uv = vec2(gl_FragCoord.x / u_resolution.x, gl_FragCoord.y / u_resolution.y);
	//uv -= 0.5;
	//uv /= vec2(u_resolution.y / u_resolution.x, 1);
	
	// Art of Code way in Ray Marching for Dummies!
	vec2 uv = (gl_FragCoord.xy -.5 * u_resolution.xy) / u_resolution.y;
	
	// Art of Code way in "Shadertoy for absolute beginners"
	// vec2 uv = gl_FragCoord.xy / u_resolution.xy; // 0 <> 1.
	// uv -= .5;  // -0.5 <> 0.5
	// uv.x *= u_resolution.x / u_resolution.y; // aspect ratio of the screen
	
	vec3 col = vec3(.0);
	
	vec3 ro = vec3(0, 2, 0.); // position of camera
	
	vec3 rd = vec3(0.);
	
	if(b_time < 36) rd = normalize(vec3(uv.x, uv.y - .2, 1)); // ray direction, normalized version of that - camera done
	if(b_time > 36) rd = normalize(vec3(atan(b_time)* sqrt(uv.x * .2)-uv.x, uv.y  / (atan(b_time) *pi), sqrt(uv.y+uv.x)));
	
	float d = RayMarch(ro, rd);
	
	if (b_time > 15 && b_time < 24) d -= .5 - (atan(u_time)*.1); // to visualize like ground moving up/down a bit, and sphere arriving/leaving
	if (b_time > 24 && b_time < 45) d -= (sqrt(1. - rd.y ) * abs(atan(b_time)) ) / pi * atan(sqrt(-sin(1.- rd.x * sin(b_time)) + (rd.y * cos(b_time)) + rd.z)); // the example before lighting
	
	vec3 p = ro + rd *d; // ray origin camera + go into ray direction, for how long? for the exact distance to get to the intersection point
	
	float dif = GetLight(p); // "diffuse lighting"
	
	//col = vec3(d); // before lighting
	//col = vec3(dif, dif / 2., dif * 2.);
	
	col = (1.+GetNormal(p)) / 2; // suggestion to improve : z values not negative : is this the right place : GetNormal is called in GetLight, should this be there? or here?
	FragColor = vec4(col.y - 0.1, col.z, col.x, 1.);
}