#version 330 core
out vec4 FragColor;

in vec3 ourColor; // is this necessary?
in vec2 TexCoord;
varying vec3 position;
vec3 could_you = position; // varying is deprecated, get a warning, should use in/out (method = just replace the words in both shaders?)
uniform vec2 u_resolution;
uniform float u_time;
uniform sampler2D texture15; // if textures // why 15. not zero or one? (need to adjust the source file of course)
float pi = 3.141592;
float time = u_time;
float b_time = u_time;
vec2 uv = gl_FragCoord.xy / u_resolution.xy;
vec2 UV = gl_FragCoord.xy/u_resolution.xy; // to change the width of the thing based on the location on screen
												// original uv coordinates without any changes :: 0,0 to 1,1    
#define S(a, b, t) smoothstep(a, b, t)

struct ray
{
	vec3 o, d;
};

ray GetRay(vec2 uv, vec3 campos, vec3 lookat, float zoom)
{
	ray a;
	a.o = campos;
	vec3 f = normalize(lookat - campos); // forward
	vec3 r = cross(vec3(0, 1, 0), f); // right
	vec3 u = cross(f, r);  // up
	vec3 c = a.o + f * zoom; // create center of screen
	vec3 i = c + uv.x * r + uv.y * u; // intersection point
	a.d = normalize(i - a.o); // ray direction
	return a;
}


vec3 closestpoint(ray r, vec3 p)
{
	return r.o + max(0., dot(p - r.o, r.d)) * r.d;
}

float distray(ray r, vec3 p)
{

	return length(p - closestpoint(r, p));

}

float Bokeh(ray r, vec3 p, float size, float blur)
{
	float d = u_time < 6 ? distray(r, p + (fract(p) / r.d.z)) : 
	u_time > 19 ? u_time > 26 ? distray(r, vec3(p.y / atan(could_you.y), mod(could_you.x, p.y), p.z ) * (fract(sin(vec3(p.x + fract(could_you.y), p.y + fract(could_you.x), p.z) * (.006 * abs(sin(u_time))) )))) : 
	distray(r, vec3(p.x / sin(could_you.y *.1), p.y, p.z + r.d.x ) * (fract(atan(r.d.y)))) 
	: distray(r , p * smoothstep ( abs( vec3(pow(p.x, 5.0), length(p.y) / r.d.y, p.z) * (mod(p.x,p.y))), (sin((p * .01 ) + cos(ceil (p.x)))) *.1, vec3(fract(p.x), dot(p.y, p.z), length(p.y))  ));

	if (u_time > 26) size *= length(p);
	float c = S(size, size*(1.-blur), d / (sin(d + u_time) * .1));
	c *= mix(.6, 1., S(size*.79, size, d));
	return c;

}

void main()
{
	vec3 col = vec3(0.);
	vec2 uv = gl_FragCoord.xy / u_resolution.xy;
	uv -= .5;
	uv.x *= u_resolution.x/ u_resolution.y;
	
	vec3 campos = vec3(0.,.2, 0.);
	vec3 lookat = vec3(0.,.2, 1.);
	ray r = GetRay(uv, campos, lookat, 2.);
	float t = time *.1;
	r.d.x = abs(r.d.x);
	r.d.y = abs(r.d.y); // ??
	//r.d.z = abs(r.d.z);
	float s = 1./10.; // 0.1
	float m = 0.;
	if (u_time < 35){
		for (float i = 0.; i < 1.; i += s)
		{
			float ti = fract(t+i);
			vec3 p = vec3(u_time > 19 ? 2. : sin(time), 2., 100.-ti* 79.);  // fract disregards whole numbers, so t goes from 0.0 to 0.99.. then 1.->1.5->1.99 but disregards everything but fractions
			m += Bokeh(r, p ,(u_time < 26 ? sin(p.y) : .05 * sin(u_time) ), .3)*ti*ti;
		}
		col = vec3(0.31 * (sin(u_time + m) / could_you.z), .5 * (sin((b_time *.3) + m) / could_you.y), .7 * (atan((b_time * .3) + m) + could_you.z));
	}
	
	FragColor = vec4(col,1.);
}