
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                          ;;
;; A Vintage Computing Christmas Challenge 2022 entry from Christopher Jam  ;;
;;                                                                          ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; assemble with ca65, using a rule like
;	cl65 -o $@ --start-addr 812 -t c64 -C c64-asm.cfg $<
;
; (overwites the CLALL vector to autostart.  Cheers Krill for the tip)


st = $2a
set_cursor = $e50c  ; writs X to xp, Y to yp
get_cp = $e513
clr = $e544

xp = $d6
yp = $d3

Rx = 9
Dx = Rx*2+1
Ry = 9
Dy = Ry*2+1

    .word start
start:
    jsr clr
    ldy#Ry+5

yloop:
    dec startx+1
startx:
    ldx#Rx+8+1+1
    dey
stop:
    beq stop
xloop:
    jsr plots
    cpx#Rx-5+1
    bne xloop
    beq yloop


plots:
    jsr plot4
plot4:
    jsr plot2
plot2:

    txa
    sty yp
    eor#$ff ; emulate rsub, rather than storing xp and subtracing it from A
    adc#Dy  ; carry is set one time in four, which advances -xp
    tay
    ldx yp

    jsr set_cursor
    lda#st
    jmp $e716 ; print knowing the destination is screen.

