
; This program depends on the XL-OS, as it uses:
; - EPB  E: handler put-byte location
; - RWS  E: handler return-with-scroll
;
; Using RWS directly has a problem: if the screen scrolls, the cursor
; is not cleared at the en-of-line, so this program only works loaded
; at start of screen.

ay = 129

EPUT = $f2B0
;EPUT = $E503

    org 140

start:

loop

yy = * + 1
    lda #16

    ; get ay = abs(y)
    jsr abs8
    sta ay
    tay

    ; get ax = abs(x)
xx = * + 1
    lda #25
    jsr abs8
    tax

    ; get w = abs(ax-ay)
    ; sec
    sbc ay
    jsr abs0
    cmp #5
    bcs space

    lda #42 ; STAR

    cpx #5
    bcc putch
    cpy #5
    bcc putch

space
    lda #32
putch
    jsr EPUT

    dec xx
    bpl loop

    ; Init X
    lda #37
    sta xx

    dec yy
    bpl loop
    rts

abs8
    sec
    sbc #8
abs0
    bpl oka
    adc #255
    eor #255
oka rts

