; C64 Christmas Star by GeirS, 2022-12-22
; Size: 49 bytes excl. load address. Assemble using 64tass.
; Autostarts by loading into zero-page. It requires "Inject into RAM" as Autostart PRG mode in the VICE emulator.

ScreenAddr      = $ad               ; Pointer to screen address
Counter         = $c2               ; Variable for counting rows and columns
AddrAdjHi       = $ecb7             ; Byte values $ff,$ff,$00,$00 are available here

                * = $44             ; Load address (autostart at label Entry which is located at $73)

; Address adjustment for each row of each triangle
AddrAdjLo       .char -40,-39,41,40

; Lo byte of initial screen address of each triangle
AddrLo          .char $e0,$dc,$9c   ; Opcode 'ldy #' below is the last byte of this table ($a0)

TriangleLoop    ldy #12             ; Row and column counter
                lda AddrLo+4,x      ; Get lo byte of screen address (zero-page addressing wraps around)
End             bpl End             ; Loop forever here when done (a=40)
                sta ScreenAddr
                cmp #$dc            ; Set carry flag if this is the 1st or 2nd triangle
                tya
                adc #-7             ; Calculate hi byte of screen address
RowLoop         jsr $f7e0           ; Set ScreenAddr+1 and Counter and clear the carry flag
                lda #$2a            ; Asterisk character
ColumnLoop      sta (ScreenAddr),y  ; Put it on screen
                dey
                bpl ColumnLoop      ; Loop for all columns
                lda ScreenAddr
                adc AddrAdjLo+4,x   ; Adjust screen address
                sta ScreenAddr
                lda ScreenAddr+1
                adc AddrAdjHi-$fc,x
                ldy Counter
                dey
                bpl RowLoop         ; Loop for all rows
                dex
Entry           bne TriangleLoop    ; Loop for all triangles (initial entry: x=$ff and zero flag is clear)
