; MEGA65 Christmas Star by GeirS, 2022-12-24
; Size: 52 bytes excl. load address and BASIC stub. Assemble using ACME.

                !cpu m65
                !to "star-52.prg",cbm

ScreenAddr      = $fb               ; Pointer to screen address

                * = $2001           ; Load address
; BASIC stub
                !word NextLine      ; Address of next line
                !word 1337          ; Line number
                !text $fe,$02,"0:"  ; Bank
                !text $9e,"8216"    ; SYS token and address
                !byte 0             ; End of line
NextLine        !word 0

; Address adjustment for each row of each triangle
AddrAdjLo       !byte -80,-79,81,80

; Lo byte of initial screen address of each triangle
AddrLo          !byte $22,$1e,$9e   ; Opcode 'ldx #' below is the last byte of this table ($a2)

; Code starts at $2018
                ldx #3              ; Index to data for 4th triangle
TriangleLoop    ldy #12             ; Row and column counter
                lda #$0b            ; Hi byte of screen address for 3rd and 4th triangle
                ldz AddrLo,x        ; Get lo byte of screen address
                bmi RowLoop         ; Branch if 3rd or 4th triangle
                lda #$0e            ; Hi byte for 1st and 2nd triangle
RowLoop         stz ScreenAddr      ; Set current screen address
                sta ScreenAddr+1
                phy                 ; Push row and column counter on stack
                lda #$2a            ; Asterisk character
ColumnLoop      sta (ScreenAddr),y  ; Put it on screen
                dey
                bpl ColumnLoop      ; Loop for all columns
                tza
                adc AddrAdjLo,x     ; Adjust lo byte of screen address ('clc' not required)
                taz
                tya                 ; y is $ff here
                adc ScreenAddr+1    ; Adjust hi byte of screen address
                cpx #2              ; Set carry flag if 3rd or 4th triangle
                adc #0              ; Adjust hi byte again if required
                ply                 ; Pull row and column counter from stack
                dey
                bpl RowLoop         ; Loop for all rows
                dex
                bpl TriangleLoop    ; Loop for all triangles
                rts
