;-------------------------------------------------------------------------------
;
; X-Mas Star 2022
; ---------------
; Vintage Computing Christmas Challenge 2022
; https://logiker.com/Vintage-Computing-Christmas-Challenge-2022
;
; Atari ST version by lsl/checkpoint
; lsl@quantentunnel.de
;
; size:             88 bytes
; executable size: 120 bytes (88 bytes +32 bytes header)
;-------------------------------------------------------------------------------
                OUTPUT 'STAR.TOS'

                OPT D-          ; no symboltable

                lea     pattern(PC),A6
                moveq   #2,D4           ; direction: forward
                moveq   #9-1,D7         ; 9 lines
                bsr.s   print_pattern_y

                subq.l  #4,A6           ; pattern+7*2
                moveq   #-2,D4          ; direction: backward
                moveq   #8-1,D7         ; 8 lines
                bsr.s   print_pattern_y
end:
                bra.s   end

print_pattern_y:
                move.w  (A6),D5         ; bit pattern
                bpl.s   not_one_more

; special case: line 5 --> 1 star more

                moveq   #'*',D1         ; star
                bsr.s   Cconout
not_one_more:
pattern_x:
                moveq   #'*',D1         ; star
                add.w   D5,D5
                bcs.s   is_star
is_space:
                moveq   #' ',D1         ; space
is_star:
                bsr.s   Cconout

                tst.w   D5
                bne.s   pattern_x

; line feed
                moveq   #$0D,D1
                bsr.s   Cconout
                moveq   #$0A,D1
                bsr.s   Cconout

                adda.w  D4,A6           ; direction
                dbra    D7,print_pattern_y
                rts
Cconout:
                move.w  D1,-(SP)
                move.w  #2,-(SP)
                trap    #1
                addq.l  #4,SP
                rts
pattern:
;                     1234567812345678
                DC.W %0000100000001000 ; 1
                DC.W %0000110000011000 ; 2
                DC.W %0000111000111000 ; 3
                DC.W %0000111101111000 ; 4
                DC.W %1111111111111111 ; 5 ===== one star more! =====
                DC.W %0111111111111111 ; 6
                DC.W %0011111111111110 ; 7
                DC.W %0001111111111100 ; 8
                DC.W %0000111111111000 ; 9

                END
