#version 460

#ifdef SPIRV_VULKAN

struct FilterCubemapParams
{
	vec4   params;		// TODO: split, this is legacy

	uint   cube_face;
	float  cone_angle;
	float  mip_level;
	float  _pad0;
};

layout (std140, row_major) uniform FilterCubemapParamsBuffer
{
	FilterCubemapParams filter_params;
};

#define miplevel filter_params.mip_level
#define cubeFace filter_params.cube_face
#define cone_angle filter_params.cone_angle
#define params filter_params.params

uniform samplerCube sSourceCubemapMip;
#define s_texture0 sSourceCubemapMip

#else

uniform float miplevel;
uniform int cubeFace;
uniform float cone_angle;
uniform vec4 params;

uniform samplerCube s_texture0;

#endif

in vec2 vTexcoord0;
out vec4 out_color;

// unit 0 - base cubemap.
// 

#define M_PI 3.1415926535897932384626433832795

float saturate(float x) {
    return clamp(x, 0.0, 1.0);
}

float rnd(vec2 uv) {
    return fract(sin(dot(uv, vec2(12.9898, 78.233) * 2.0)) * 43758.5453);
}

const float PI = 3.14159265358979;
vec3 hemisphereSample_cos(vec2 uv, mat3 vecSpace, vec3 cubeDir, float gloss) { // cos + lerped cone size (better than just lerped)
    float phi = uv.y * 2.0 * PI;
    float cosTheta = sqrt(1.0 - uv.x);
    float sinTheta = sqrt(1.0 - cosTheta * cosTheta);
    vec3 sampleDir = vec3(cos(phi) * sinTheta, sin(phi) * sinTheta, cosTheta);
    return normalize(mix(vecSpace * sampleDir, cubeDir, params.y));
}

vec3 hemisphereSample_phong(vec2 uv, mat3 vecSpace, vec3 cubeDir, float specPow) {
    float phi = uv.y * 2.0 * PI;
    float cosTheta = pow(1.0 - uv.x, 1.0 / (specPow + 1.0));
    float sinTheta = sqrt(1.0 - cosTheta * cosTheta);
    vec3 sampleDir = vec3(cos(phi) * sinTheta, sin(phi) * sinTheta, cosTheta);
    return vecSpace * sampleDir;
}

mat3 matrixFromVector(vec3 n) { // frisvad
    float a = 1.0 / (1.0 + n.z);
    float b = -n.x * n.y * a;
    vec3 b1 = vec3(1.0 - n.x * n.x * a, b, -n.x);
    vec3 b2 = vec3(b, 1.0 - n.y * n.y * a, -n.y);
    return mat3(b1, b2, n);
}

vec4 encodeRGBM(vec4 color) { // modified RGBM
    color.rgb = pow(color.rgb, vec3(0.5));
    color.rgb *= 1.0 / 8.0;

    color.a = saturate( max( max( color.r, color.g ), max( color.b, 1.0 / 255.0 ) ) );
    color.a = ceil(color.a * 255.0) / 255.0;

    color.rgb /= color.a;
    return color;
}


void main() {

	// input is in range of 0...1 and y-inverted (top-bottom)
	vec2 pos = vTexcoord0.xy;
	pos.y = 1.0 - pos.y;
	pos = 2.0 * (pos.xy - vec2(0.5, 0.5));
	
    vec3 normal = normalize( vec3(pos.xy, 1.0) );
    if(cubeFace==2)
        normal = normalize( vec3(pos.x,  1.0, -pos.y) );
    else if(cubeFace==3)
        normal = normalize( vec3(pos.x, -1.0,  pos.y) );
    else if(cubeFace==0)
        normal = normalize( vec3(  1.0, pos.y,-pos.x) );
    else if(cubeFace==1)
        normal = normalize( vec3( -1.0, pos.y, pos.x) );
    else if(cubeFace==5)
        normal = normalize( vec3(-pos.x, pos.y, -1.0) );

    vec3 up = vec3(0.0, 1.0, 0.0);
    vec3 right = normalize(cross(up,normal));
    up = cross(normal,right);

	mat3 vecSpace = matrixFromVector(normalize(normal));
	
	#if 0

    vec3 sampledColour = vec3(0.0, 0.0, 0.0);
    float index = 0.0;
	
    for(float phi = 0.0; phi < 6.283; phi += 0.025)
    {
        for(float theta = 0.0; theta < cone_angle; theta += 0.01)
        {
            vec3 temp = cos(phi) * right + sin(phi) * up;
            vec3 sampleVector = cos(theta) * normal + sin(theta) * temp;
            sampledColour += textureLod(s_texture0, sampleVector, miplevel).rgb * cos(theta) * sin(theta);
            index += 1.0;
        }
    }

	//sampledColour = texture(s_texture0, normal).rgb;
	//glFragColor = vec4(sampledColour, 1.0);
    out_color = vec4(M_PI * sampledColour / index, 1.0 ) * 3.0;
	
	#else

	vec4 color = vec4(0.0);
	const int samples = 4096;
    vec3 vect;
    for(int i=0; i<samples; i++) {
        float sini = sin(float(i));
        float cosi = cos(float(i));
        float rand = rnd(vec2(sini, cosi));

        vect = hemisphereSample_phong(vec2(float(i) / float(samples), rand), vecSpace, normal, 500.0 / params.y);

		vect.y = -vect.y;
        color += textureLod(s_texture0, vect, 0);
    }
    color /= float(samples);

    out_color = color;// params.w < 2.0? color : encodeRGBM(color);
	//out_color.xz = vec2(1.0f);

	#endif
	
}