#version 300 es

precision mediump float;
in vec3 vNorm;
in vec4 vPos;
in vec4 vCoords;
in vec4 vWorldPos;
in vec3 vWorldNorm;
in vec2 vTCoord;

// output for 2 buffers
layout(location = 0) out vec4 outAlbedo;
layout(location = 1) out vec4 outNormalMaterial;

// albedo
uniform sampler2D s_texture0;

// normal
uniform sampler2D s_texture1;

// material id
uniform float materialId;

void main() {
	float g = vNorm.z * 0.5 + 0.5;
	outNormalMaterial = vec4(normalize(vWorldNorm) * 0.5 + 0.5, materialId);
	outAlbedo = texture(s_texture0, vTCoord);
}