#version 430

in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

struct GlowParams
{
	vec2 resolution;
	vec2 inv_resolution;

	vec3 threshold;
	float _pad0;

	vec3 color;
	float _pad1;

	float iteration;
};

layout (std140, row_major) uniform GlowParamsBuffer {
	GlowParams glow_params;
};

#ifdef PASS_BLUR

uniform sampler2D s_texture0;

vec3 threshold_input(vec3 inpt)
{
	return max(vec3(0.0), inpt - glow_params.threshold.xyz);
}

vec3 KawaseBlurFilter(sampler2D tex, vec2 texCoord, vec2 pixelSize, float distance)
{
	vec2 texCoordSample;
	vec2 dUV = (pixelSize.xy * distance);

	vec3 cOut;
	//texCoord.x += 0.5 * pixelSize;
	//texCoord += 0.5 * pixelSize;


	// Sample top left pixel
	texCoordSample.x = texCoord.x - dUV.x;
	texCoordSample.y = texCoord.y + dUV.y;
	
	cOut = texture( tex, texCoordSample ).xyz;

	// Sample top right pixel
	texCoordSample.x = texCoord.x + dUV.x;
	texCoordSample.y = texCoord.y + dUV.y;

	cOut += texture( tex, texCoordSample ).xyz;

	// Sample bottom right pixel
	texCoordSample.x = texCoord.x + dUV.x;
	texCoordSample.y = texCoord.y - dUV.y;
	cOut += texture( tex, texCoordSample ).xyz;

	// Sample bottom left pixel
	texCoordSample.x = texCoord.x - dUV.x;
	texCoordSample.y = texCoord.y - dUV.y;

	cOut += texture( tex, texCoordSample ).xyz;

	// Average 
	cOut *= 0.25f;
	
	return threshold_input(cOut);
}

void main()
{
	if (glow_params.iteration == 0.0) // first iteration is downsampling 50%
	{
		vec2 tc = vTexcoord0;
		outColor = vec4(KawaseBlurFilter(s_texture0, tc, glow_params.inv_resolution, glow_params.iteration + 0.5), 1.0);
	}
	else
	{
		vec2 tc = vTexcoord0;
		outColor = vec4(KawaseBlurFilter(s_texture0, tc, glow_params.inv_resolution * 0.5, glow_params.iteration + 0.5), 1.0);
	}
}

#endif

#ifdef PASS_MERGE

uniform sampler2D s_texture0;  // base image (HDR)
uniform sampler2D s_texture1;  // glow (HDR)

void main()
{
	//vec4 pxl = texture(s_texture0, vTexcoord0);
	vec4 pxl = texelFetch(s_texture0, ivec2(vTexcoord0 * glow_params.resolution), 0);
	vec4 glow = texture(s_texture1, vTexcoord0) * vec4(glow_params.color.rgb, 1.0);
	//vec4 glow = texelFetch(s_texture1, ivec2(vTexcoord0 * glow_params.resolution * 0.5), 0) * vec4(glow_params.color.rgb, 1.0);
	outColor = pxl + glow;
	
}


#endif
