#version 460

#ifndef SPIRV_ENABLED
#extension GL_NV_gpu_shader5 : enable
#endif

#define GEOMETRY_INFORMATION_STATIC 1

#include <shaders/materials/commons.glsl>
#include <shaders/materials/commons_gradient.glsl>

#include <shaders/materials/mapping/triplanar.glsl>

#ifndef GEOMETRY_PASS
#ifndef SPIRV_ENABLED
in Vertex
{
	vec3 vCoords;
	f16vec3 vNorm;
	f16vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vWorldPos;
	f16vec4 vColor;
	f16vec2 vUV0;
} vtx_input;
#else
layout(location = 1) in struct
{
	vec3 vCoords;
	f16vec3 vNorm;
	f16vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vWorldPos;
	f16vec4 vColor;
	f16vec2 vUV0;
} vtx_input;
layout(location = 0) in flat uint instanceID;
#endif
#endif

layout(std140, row_major) uniform TransformParamsBuffer{
	EntityTransformParams transform_params;
};


// output for 2 buffers
#ifdef DEFERRED_PASS
layout(location = 0) out vec4 outAlbedo;
layout(location = 1) out uint outNormalMaterial;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;
layout(location = 3) out vec4 outEmissive;
#endif

#ifdef SPIRV_ENABLED
layout(std140, row_major) uniform BaseMaterialPropertiesBuffer
{
	vec4 colorDiffuse;
	int gUseDerivedNormal;
	int gMaterialMode;
	int materialId;
	int materialIndex;
	int componentTags;
};
#else
uniform int gUseDerivedNormal = 0;
uniform int gMaterialMode = 0;
uniform vec4 colorDiffuse;
uniform int materialId;
uniform int materialIndex;
uniform int componentTags;
#endif

#if !defined(GEOMETRY_PASS)
#include <shaders/materials/material_overrides.glsl>
#endif

#if 0
struct material_input_params
{
	vec3 world_coords;
	vec3 local_coords;
	vec3 world_normal;
	vec3 local_normal;
	vec3 uv0;
	vec3 color_albedo;
	vec3 color_emissive; // NOTE: Be careful here, as this will not be passed to the 

	MaterialPropertiesGPU material;
};
#endif

void main() {

#if defined(GEOMETRY_PASS)
#endif

#if defined(SHADOWMAP_PASS)
#ifdef MATERIAL_PROPERTIES_BINDING
	MaterialPropertiesGPU material = materials.material_properties[materialIndex];
#else
	MaterialPropertiesGPU material;
	material.diffuse = colorDiffuse.rgb;
	material.emissive = vec3(0.0f);
	material.metalness = 0.0f;
	material.roughness = 0.5f;
	material.transparency = 0.0f;
	material.refraction = 0.0f;
	material.flags = 0;

#endif

	bool to_discard = getMaterialDiscard(material, vtx_input.vWorldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);
	if (to_discard)
	{
		// NOTE: yeah, this will break derivatives...
		discard;
		return;
	}
#endif

#ifdef DEFERRED_PASS

#ifdef MATERIAL_PROPERTIES_BINDING
	MaterialPropertiesGPU material = materials.material_properties[materialIndex];
#else
	MaterialPropertiesGPU material;
	material.diffuse = colorDiffuse.rgb;
	material.emissive = vec3(0.0f);
	material.metalness = 0.0f;
	material.roughness = 0.5f;
	material.transparency = 0.0f;
	material.refraction = 0.0f;
	material.flags = 0;

#endif

	// output normal only
	//gl_FragColor = vec4(vNorm * 0.5 + 0.5, 0.0);
	float g = vtx_input.vNorm.z * 0.5 + 0.5;
	//outColor = vec4(vec3(vCoords.z/vCoords.w) * 0.5 + 0.5, 0.0);
	//outColor = vec4(vec3(vWorldPos.z/10.0) + 1.0, 0.0);
	//outColor = vec4(vec3(vWorldPos.y/5.0) + 0.5, 0.0);
	//gl_FragColor = vec4(g);
	//gl_FragColor = vec4(0.5, 0.6, 0.7, 0.0);
	vec3 worldNorm = vtx_input.vWorldNorm;
	vec3 norm = vtx_input.vNorm;
	
	if ((material.flags & MaterialFlag_Flat) != 0)
	{
		vec3 dFdxPos;
		vec3 dFdyPos;
		dFdxPos = dFdx(vtx_input.vWorldPos.xyz);
		dFdyPos = dFdy(vtx_input.vWorldPos.xyz);
		worldNorm = cross(dFdyPos, dFdxPos);

		dFdxPos = dFdx(vtx_input.vLocalPos.xyz);
		dFdyPos = dFdy(vtx_input.vLocalPos.xyz);
		norm = normalize(cross(dFdyPos, dFdxPos));

#ifdef SPIRV_ENABLED
		worldNorm = -worldNorm;
		norm = -norm;
#endif
	}

	
	vec3 normal = normalize(worldNorm);
	normal = getMaterialNormal(material, normal, vtx_input.vWorldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);

	bool to_discard = getMaterialDiscard(material, vtx_input.vWorldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);
	if (to_discard)
	{
		// NOTE: yeah, this will break derivatives...
		discard;
		return;
	}

	if (material.normal_sampler >= 0 && material.normal_sampler < 16)
	{
		if ((material.flags & MaterialFlag_TriPlanarMapping) == 0)
		{
			// we need full transformation frame
			vec3 pos_dx = dFdx(vtx_input.vWorldPos);
			vec3 pos_dy = dFdy(vtx_input.vWorldPos);
			vec3 tex_dx = dFdx(vec3(vtx_input.vUV0, 0.0));
			vec3 tex_dy = dFdy(vec3(vtx_input.vUV0, 0.0));

			float denom = tex_dx.x * tex_dy.y - tex_dy.x * tex_dx.y;
			if (abs(denom) >= 0.0000000001)
			{
				vec3 t = (tex_dy.y * pos_dx - tex_dx.y * pos_dy) / denom;
				vec3 ng = normal;

				t = normalize(t - ng * dot(ng, t));
				vec3 b = normalize(cross(ng, t));
				mat3 tbn = mat3(t, b, ng);

				vec3 n = texture(material_textures[material.normal_sampler], vtx_input.vUV0).rgb * 2.0 - 1.0;

				n = mix(vec3(0.0, 0.0, 1.0), n, material.normal_factor);
				n = normalize( n * transpose(tbn) );

				normal.rgb = n;
			}
		}
		else
		{
			vec3 n = mapping_triplanar_normal(material_textures[material.normal_sampler], vtx_input.vLocalPos.xyz, norm, material.triplanar_factor).rgb;
			n = vector_transform_by_mat43(n, transform_params.mModelNormal);
			n = normalize(n);

			n = mix(normal, n, material.normal_factor);
			normal.rgb = n;
		}
	}

	vec2 uv0 = vtx_input.vUV0;

	outNormalMaterial = encode_normal_material(normal, materialId);
	outAlbedo = vec4(1.0);
	outAlbedo = getMaterialAlbedo(material, outAlbedo, vtx_input.vWorldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);

	if (material.albedo_sampler >= 0 && material.albedo_sampler < 16)
	{
		if ((material.flags & MaterialFlag_TriPlanarMapping) != 0)
			outAlbedo.rgba *= mapping_triplanar(material_textures[material.albedo_sampler], vtx_input.vLocalPos.xyz, norm, material.triplanar_factor).rgba;
		else
			outAlbedo.rgba *= texture(material_textures[material.albedo_sampler], uv0).rgba;
	}

	outAlbedo.rgb *= vtx_input.vColor.rgb;
	//outAlbedo.rgb = 0.5 + normal * 0.5;
	
	outEmissive = vec4(0.0);
	outEmissive.rgb = getMaterialEmissive(material, outEmissive.rgb, vtx_input.vWorldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);
	
	if (false)
	if (material.emissive_sampler >= 0 && material.emissive_sampler < 16)
	{
		if ((material.flags & MaterialFlag_TriPlanarMapping) != 0)
			outEmissive.rgb *= mapping_triplanar(material_textures[material.emissive_sampler], vtx_input.vLocalPos.xyz, norm, material.triplanar_factor).rgb;
		else
			outEmissive.rgb *= texture(material_textures[material.emissive_sampler], uv0).rgb;
	}

	float roughness = material.roughness;
	roughness = getMaterialRoughness(material, roughness, vtx_input.vWorldPos.xyz, vtx_input.vLocalPos.xyz, vtx_input.vNorm, vtx_input.vWorldNorm);

	if (material.metalic_roughness_sampler >= 0 && material.metalic_roughness_sampler < 16)
		roughness *= clamp(texture(material_textures[material.metalic_roughness_sampler], uv0).g, 0.0, 1.0);

	outMetalnessRoughnessMeterialTags.rg = encode_metalness_roughness_material(material.metalness, roughness, materialIndex);
	outMetalnessRoughnessMeterialTags.ba = encode_component_tags(componentTags);

	// simple debugging
	#if 0
	outAlbedo.rg = uv0;
	outAlbedo.b = 0.0;
	#endif

#endif
}