attribute vec3 vPosition;
attribute vec2 vTexcoord;
uniform mat4 mModelview;
uniform mat4 mProjection;
uniform mat4 mRotation;
varying mediump vec3 vDirection;

void main() {
	gl_Position = mProjection * mModelview * vec4(vPosition, 1.0);
	
	vDirection = vPosition * 0.019;

	vDirection.z = 0.3;
	vDirection = (mRotation * vec4(normalize(vDirection), 1.0)).xyz;
	vDirection.y *= 16.0 / 9.0;
}