#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct InstanceModifierRandomizer_Params
{
    vec3 position;
    int falloff_curve_idx;
    vec3 falloff_radius;
    int falloff_inverse;
    vec3 position_modifier_base;
    int randomness_seed;
    vec3 position_modifier_range;
    int replace_previous_rotation_scale;
    vec3 rotation_modifier_base;
    int replace_previous_position;
    vec3 rotation_modifier_range;
    int randomization_input;
    vec3 scale_modifier_base;
    int color_gradient_idx;
    vec3 scale_modifier_range;
    float randomness;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
};

struct ProcessInstanceModifiersParams
{
    int buffer_capacity;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct link_list_node
{
    uint value;
    uint next;
};

layout(set = 0, binding = 6, std140) uniform ProcessInstanceModifiersParamsBuffer
{
    ProcessInstanceModifiersParams process_modifiers_params;
} _587;

layout(set = 0, binding = 7, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _600;

layout(set = 0, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _612;

layout(set = 0, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _635;

layout(set = 0, binding = 3, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _660;

layout(set = 0, binding = 4, std430) buffer VM0
{
    InstanceModifierRandomizer_Params VM0_params;
} _668;

layout(set = 0, binding = 5, std430) buffer VM1
{
    InstanceModifierRandomizer_Params VM1_params;
} _682;

layout(set = 0, binding = 8) uniform sampler2D s_Gradients;
layout(set = 0, binding = 9) uniform sampler2D s_Curves;

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _93 = hash(param);
    uint param_1 = v.z;
    uint _99 = hash(param_1);
    uint param_2 = (v.x ^ _93) ^ _99;
    uint _102 = hash(param_2);
    return _102;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _132 = floatConstruct(param_1);
    return _132;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _122 = hash(param);
    uint param_1 = _122;
    float _124 = floatConstruct(param_1);
    return _124;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void instance_modifier_randomizer(InstanceModifierRandomizer_Params modifier_params, inout Instance instance, uint id)
{
    vec3 rel_coords = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    float influence = length((rel_coords - modifier_params.position) / modifier_params.falloff_radius);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse == 0)
    {
        influence = 1.0 - influence;
    }
    int param = modifier_params.falloff_curve_idx;
    float param_1 = influence;
    influence = curve_sample(param, param_1);
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param_2 = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param_2);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_3 = uintBitsToFloat(instance.hash);
        fid = random(param_3);
    }
    float param_4 = fid;
    vec3 angles;
    angles.x = random(param_4);
    float param_5 = fid + 123.3000030517578125;
    angles.y = random(param_5);
    float param_6 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_6);
    angles = modifier_params.rotation_modifier_base + (angles * modifier_params.rotation_modifier_range);
    float param_7 = fid;
    vec3 scales;
    scales.x = random(param_7) * modifier_params.randomness;
    scales.y = scales.x;
    scales.z = scales.x;
    scales = modifier_params.scale_modifier_base + (scales * modifier_params.scale_modifier_range);
    float param_8 = fid;
    vec3 translations;
    translations.x = random(param_8);
    float param_9 = fid + 123.73169708251953125;
    translations.y = random(param_9);
    float param_10 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_10);
    translations = normalize(translations);
    translations = modifier_params.position_modifier_base + (translations * modifier_params.position_modifier_range);
    translations *= modifier_params.randomness;
    angles *= influence;
    translations *= influence;
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        scales = mix(vec3(1.0), scales, vec3(influence));
    }
    else
    {
        scales = mix(vec3(0.0), scales, vec3(influence));
    }
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
    if (modifier_params.color_gradient_idx != (-1))
    {
        float param_11 = fid;
        float color_t = random(param_11) * modifier_params.randomness;
        int param_12 = modifier_params.color_gradient_idx;
        float param_13 = fract(color_t);
        vec4 g = gradient_sample(param_12, param_13);
        instance.c = mix(instance.c, g, vec4(influence));
    }
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (id >= uint(_587.process_modifiers_params.buffer_capacity))
    {
        return;
    }
    if (id >= uint(_600.instance_params.instance_count))
    {
        return;
    }
    Instance instance;
    instance.m0 = _612.instance_transform[(id * 3u) + 0u];
    instance.m1 = _612.instance_transform[(id * 3u) + 1u];
    instance.m2 = _612.instance_transform[(id * 3u) + 2u];
    vec2 _642 = unpackHalf2x16(_635.instance_color[(id * 2u) + 0u]);
    instance.c.x = _642.x;
    instance.c.y = _642.y;
    vec2 _652 = unpackHalf2x16(_635.instance_color[(id * 2u) + 1u]);
    instance.c.z = _652.x;
    instance.c.w = _652.y;
    instance.hash = _660.instance_hash[id];
    InstanceModifierRandomizer_Params _673;
    _673.position = _668.VM0_params.position;
    _673.falloff_curve_idx = _668.VM0_params.falloff_curve_idx;
    _673.falloff_radius = _668.VM0_params.falloff_radius;
    _673.falloff_inverse = _668.VM0_params.falloff_inverse;
    _673.position_modifier_base = _668.VM0_params.position_modifier_base;
    _673.randomness_seed = _668.VM0_params.randomness_seed;
    _673.position_modifier_range = _668.VM0_params.position_modifier_range;
    _673.replace_previous_rotation_scale = _668.VM0_params.replace_previous_rotation_scale;
    _673.rotation_modifier_base = _668.VM0_params.rotation_modifier_base;
    _673.replace_previous_position = _668.VM0_params.replace_previous_position;
    _673.rotation_modifier_range = _668.VM0_params.rotation_modifier_range;
    _673.randomization_input = _668.VM0_params.randomization_input;
    _673.scale_modifier_base = _668.VM0_params.scale_modifier_base;
    _673.color_gradient_idx = _668.VM0_params.color_gradient_idx;
    _673.scale_modifier_range = _668.VM0_params.scale_modifier_range;
    _673.randomness = _668.VM0_params.randomness;
    InstanceModifierRandomizer_Params param = _673;
    Instance param_1 = instance;
    uint param_2 = id;
    instance_modifier_randomizer(param, param_1, param_2);
    instance = param_1;
    InstanceModifierRandomizer_Params _686;
    _686.position = _682.VM1_params.position;
    _686.falloff_curve_idx = _682.VM1_params.falloff_curve_idx;
    _686.falloff_radius = _682.VM1_params.falloff_radius;
    _686.falloff_inverse = _682.VM1_params.falloff_inverse;
    _686.position_modifier_base = _682.VM1_params.position_modifier_base;
    _686.randomness_seed = _682.VM1_params.randomness_seed;
    _686.position_modifier_range = _682.VM1_params.position_modifier_range;
    _686.replace_previous_rotation_scale = _682.VM1_params.replace_previous_rotation_scale;
    _686.rotation_modifier_base = _682.VM1_params.rotation_modifier_base;
    _686.replace_previous_position = _682.VM1_params.replace_previous_position;
    _686.rotation_modifier_range = _682.VM1_params.rotation_modifier_range;
    _686.randomization_input = _682.VM1_params.randomization_input;
    _686.scale_modifier_base = _682.VM1_params.scale_modifier_base;
    _686.color_gradient_idx = _682.VM1_params.color_gradient_idx;
    _686.scale_modifier_range = _682.VM1_params.scale_modifier_range;
    _686.randomness = _682.VM1_params.randomness;
    InstanceModifierRandomizer_Params param_3 = _686;
    Instance param_4 = instance;
    uint param_5 = id;
    instance_modifier_randomizer(param_3, param_4, param_5);
    instance = param_4;
    _612.instance_transform[(id * 3u) + 0u] = instance.m0;
    _612.instance_transform[(id * 3u) + 1u] = instance.m1;
    _612.instance_transform[(id * 3u) + 2u] = instance.m2;
    _635.instance_color[(id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _635.instance_color[(id * 2u) + 1u] = packHalf2x16(instance.c.zw);
}

 