#version 450
layout(local_size_x = 32, local_size_y = 1, local_size_z = 1) in;

struct DispatchIndirectParams
{
    uint x;
    uint y;
    uint z;
};

struct BuildDispatchIndirectFromBufferParams
{
    uint indirect_buffer_idx;
    uint src_buffer_offset_x;
    uint src_buffer_data_numerator_x;
    uint src_buffer_data_denominator_x;
    uint src_buffer_offset_y;
    uint src_buffer_data_numerator_y;
    uint src_buffer_data_denominator_y;
    uint src_buffer_offset_z;
    uint src_buffer_data_numerator_z;
    uint src_buffer_data_denominator_z;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

layout(set = 0, binding = 1, std430) buffer DispatchIndirectParamsBuffer
{
    DispatchIndirectParams dispatch_indirect_params[];
} _26;

layout(set = 0, binding = 3, std140) uniform BuildDispatchIndirectFromBufferParamsBuffer
{
    BuildDispatchIndirectFromBufferParams params;
} _32;

layout(set = 0, binding = 2, std430) buffer DispatchIndirectSourceBuffer
{
    uint dispatch_indirect_src_data[];
} _39;

layout(set = 0, binding = 4, std140) uniform DispatchIndirectInstanceParamsBuffer
{
    InstanceParams dispatch_indirect_instance_params;
} _53;

void main()
{
    uint idx = gl_GlobalInvocationID.x;
    if (idx == 0u)
    {
        _26.dispatch_indirect_params[_32.params.indirect_buffer_idx].x = ((((_39.dispatch_indirect_src_data[_32.params.src_buffer_offset_x] * _32.params.src_buffer_data_numerator_x) * uint(min(_53.dispatch_indirect_instance_params.buffer_capacity, _53.dispatch_indirect_instance_params.instance_count))) + _32.params.src_buffer_data_denominator_x) - 1u) / _32.params.src_buffer_data_denominator_x;
        _26.dispatch_indirect_params[_32.params.indirect_buffer_idx].y = 1u;
        _26.dispatch_indirect_params[_32.params.indirect_buffer_idx].z = 1u;
        if (_32.params.src_buffer_data_numerator_y > 0u)
        {
            _26.dispatch_indirect_params[_32.params.indirect_buffer_idx].y = (((_39.dispatch_indirect_src_data[_32.params.src_buffer_offset_y] * _32.params.src_buffer_data_numerator_y) + _32.params.src_buffer_data_denominator_y) - 1u) / _32.params.src_buffer_data_denominator_y;
        }
        if (_32.params.src_buffer_data_numerator_z > 0u)
        {
            _26.dispatch_indirect_params[_32.params.indirect_buffer_idx].z = (((_39.dispatch_indirect_src_data[_32.params.src_buffer_offset_z] * _32.params.src_buffer_data_numerator_z) + _32.params.src_buffer_data_denominator_z) - 1u) / _32.params.src_buffer_data_denominator_z;
        }
    }
}

 