#version 450

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1) uniform sampler2D sDepth;

void main()
{
    ivec2 p = ivec2(gl_FragCoord.xy) * ivec2(2);
    float depth00 = texelFetch(sDepth, p + ivec2(0), 0).x;
    float depth01 = texelFetch(sDepth, p + ivec2(0, 1), 0).x;
    float depth10 = texelFetch(sDepth, p + ivec2(1, 0), 0).x;
    float depth11 = texelFetch(sDepth, p + ivec2(1), 0).x;
    float min_depth = min(depth00, depth01);
    min_depth = min(min_depth, depth10);
    min_depth = min(min_depth, depth11);
    gl_FragDepth = min_depth;
}

 