#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _20;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    vec4 base_color = vec4(0.0, 0.0, 0.0, 1.0);
    float offset = _20.params.param1 / 100.0;
    float x = vTexcoord0.y;
    x -= offset;
    if (x > 0.0)
    {
        x = step(fract(x * 64.0), 0.1500000059604644775390625);
    }
    else
    {
        x = 0.0;
    }
    vec3 _54 = vec3(x);
    base_color.x = _54.x;
    base_color.y = _54.y;
    base_color.z = _54.z;
    outColor = base_color;
}

 