#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

const uvec2 _1065[4] = uvec2[](uvec2(0u), uvec2(0u, 1u), uvec2(1u, 0u), uvec2(1u));

struct VXParams
{
    float average_position_factor;
    float average_normals_factor;
    float average_colors_factor;
    float light_falloff_factor;
    float occlusion_falloff_factor;
    float light_trace_distance_scale;
    float trace_range;
    float reprojection_tolerance;
    int filter_step;
    int compute_diffuse;
    int compute_specular;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct link_list_node
{
    uint value;
    uint next;
};

layout(set = 0, binding = 2, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _201;

layout(set = 0, binding = 3, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _380;

layout(set = 0, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_voxelize;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 4, std140) uniform VoxelLightingParams
{
    VXParams voxel_lighting_setup;
} _1198;

layout(set = 0, binding = 8) uniform sampler2DArray s_BlueNoise;
layout(set = 0, binding = 5, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 6, rgba16f) uniform writeonly image2D imTarget;
layout(set = 0, binding = 9) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 7, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 10) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 11) uniform sampler3D s_voxel_occupancy_filtered;
layout(set = 0, binding = 12) uniform sampler2D sTextureDepthPrevious;
layout(set = 0, binding = 13) uniform sampler2D sTargetPrevious;

int decode_material(uint data)
{
    return int(data >> 31u);
}

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

float linearizeDepth(float d)
{
    return _201.dispatch_setup.near_far_plane.z / ((_201.dispatch_setup.near_far_plane.y + _201.dispatch_setup.near_far_plane.x) - (d * _201.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return (_201.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

mat3 matrixFromVector(inout vec3 n)
{
    if (n.z == (-1.0))
    {
        n.z = -0.99500000476837158203125;
    }
    float a = 1.0 / (1.0 + n.z);
    float b = ((-n.x) * n.y) * a;
    vec3 b1 = vec3(1.0 - ((n.x * n.x) * a), b, -n.x);
    vec3 b2 = vec3(b, 1.0 - ((n.y * n.y) * a), -n.y);
    return mat3(vec3(b1), vec3(b2), vec3(n));
}

vec3 CosineSampleHemisphere(float u1, float u2)
{
    float r = sqrt(u1);
    float theta = 6.283185482025146484375 * u2;
    float x = r * cos(theta);
    float y = r * sin(theta);
    return vec3(x, y, sqrt(max(0.0, 1.0 - u1)));
}

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _176 = v;
    float _180 = v.w;
    vec3 _183 = (_176.xyz * _180) * 128.0;
    v.x = _183.x;
    v.y = _183.y;
    v.z = _183.z;
    return v.xyz * v.xyz;
}

vec4 rt_cone_trace_occlusion(ivec2 screen_pos, sampler3D voxel_color_texture, sampler3D voxel_occupancy_texture, vec3 grid_size, int grid_res, vec3 grid_origin, inout vec3 origin, vec3 surface_normal, vec3 dir, float range, float lightTraceDistanceScale, float roughness, int rays, float color_falloff, float occlusion_falloff, float trace_range)
{
    if (range <= 0.0)
    {
        return vec4(0.0);
    }
    float occ = 0.0;
    vec3 occ_color = vec3(0.0);
    origin += ((surface_normal * range) * 3.0);
    vec3 param = dir;
    mat3 _361 = matrixFromVector(param);
    mat3 vecSpace = _361;
    for (int si = 0; si < rays; si++)
    {
        vec3 p = origin;
        vec3 c_color = vec3(0.0);
        float c_occlusion = 0.0;
        float base_d = 0.0;
        int frame = _380.globals.monotonic;
        vec2 hash = fract(texelFetch(s_BlueNoise, ivec3(screen_pos, si), 0).xy + vec2(float(frame) * 1.61803400516510009765625));
        float param_1 = hash.x * roughness;
        float param_2 = hash.y;
        vec3 d = CosineSampleHemisphere(param_1, param_2);
        d = vecSpace * d;
        base_d = 0.5 + hash.x;
        float lod = 1.5;
        float l = base_d * 0.5;
        float max_l = 0.0;
        float coneAperture = tan(((roughness * 3.1415927410125732421875) * 0.5) * 0.100000001490116119384765625);
        float range_rcp = 1.0 / range;
        int steps = 0;
        bool is_inside = false;
        int iter = 0;
        bool loop = true;
        while (loop)
        {
            float diameter = max(range, (2.0 * coneAperture) * l);
            float mip = min(3.5, log2(diameter * range_rcp));
            vec3 grid_p = ((p + (d * l)) - grid_origin) / grid_size;
            vec3 sample_p = (grid_p + vec3(0.5)) / vec3(float(grid_res));
            if (is_inside == false)
            {
                bool _494 = all(greaterThanEqual(sample_p, vec3(0.0)));
                bool _501;
                if (_494)
                {
                    _501 = all(lessThan(sample_p, vec3(1.0)));
                }
                else
                {
                    _501 = _494;
                }
                if (_501)
                {
                    is_inside = true;
                }
            }
            else
            {
                bool _507 = any(lessThan(sample_p, vec3(0.0)));
                bool _514;
                if (!_507)
                {
                    _514 = any(greaterThanEqual(sample_p, vec3(1.0)));
                }
                else
                {
                    _514 = _507;
                }
                if (_514)
                {
                    is_inside = false;
                    loop = false;
                    iter++;
                }
            }
            float mip_coarse = min(3.5, mip + 1.0);
            vec4 gc = vec4(textureLod(voxel_occupancy_texture, sample_p, mip_coarse).xxxx);
            if (gc.w > 0.0040000001899898052215576171875)
            {
                gc.w = textureLod(voxel_occupancy_texture, sample_p, mip).x;
                vec4 param_3 = textureLod(voxel_color_texture, sample_p, mip);
                vec3 _551 = color_convert_rgbm_rgb(param_3);
                vec3 _555 = vec3(_551);
                gc.x = _555.x;
                gc.y = _555.y;
                gc.z = _555.z;
            }
            if (gc.w > 0.75)
            {
                gc.w = 1.0;
            }
            float blend = 1.0 - c_occlusion;
            c_occlusion = min(1.0, c_occlusion + gc.w);
            c_color += (gc.xyz * blend);
            l += (diameter * lightTraceDistanceScale);
            if (l >= trace_range)
            {
                loop = false;
            }
            if (c_occlusion >= 0.99500000476837158203125)
            {
                loop = false;
            }
            if (mip >= 1.5)
            {
                break;
            }
        }
        while (loop)
        {
            float diameter_1 = max(range, (2.0 * coneAperture) * l);
            float mip_1 = min(3.5, log2(diameter_1 * range_rcp));
            vec3 grid_p_1 = ((p + (d * l)) - grid_origin) / grid_size;
            vec3 sample_p_1 = (grid_p_1 + vec3(0.5)) / vec3(float(grid_res));
            if (is_inside == false)
            {
                bool _646 = all(greaterThanEqual(sample_p_1, vec3(0.0)));
                bool _652;
                if (_646)
                {
                    _652 = all(lessThan(sample_p_1, vec3(1.0)));
                }
                else
                {
                    _652 = _646;
                }
                if (_652)
                {
                    is_inside = true;
                }
            }
            else
            {
                bool _658 = any(lessThan(sample_p_1, vec3(0.0)));
                bool _665;
                if (!_658)
                {
                    _665 = any(greaterThanEqual(sample_p_1, vec3(1.0)));
                }
                else
                {
                    _665 = _658;
                }
                if (_665)
                {
                    is_inside = false;
                    loop = false;
                    iter++;
                }
            }
            if (is_inside)
            {
                vec4 gc_1 = vec4(0.0);
                gc_1.w = textureLod(voxel_occupancy_texture, sample_p_1, mip_1).x;
                if (gc_1.w > 0.0040000001899898052215576171875)
                {
                    vec4 param_4 = textureLod(voxel_color_texture, sample_p_1, mip_1);
                    vec3 _690 = color_convert_rgbm_rgb(param_4);
                    vec3 _694 = vec3(_690);
                    gc_1.x = _694.x;
                    gc_1.y = _694.y;
                    gc_1.z = _694.z;
                }
                if (gc_1.w > 0.75)
                {
                    gc_1.w = 1.0;
                }
                float blend_1 = 1.0 - c_occlusion;
                c_occlusion = min(1.0, c_occlusion + gc_1.w);
                c_color += (gc_1.xyz * blend_1);
            }
            l += (diameter_1 * lightTraceDistanceScale);
            if (l >= trace_range)
            {
                loop = false;
            }
            if (c_occlusion >= 0.99500000476837158203125)
            {
                loop = false;
            }
        }
        c_occlusion = min(1.0, c_occlusion);
        float power = 0.75;
        occ += (c_occlusion / pow(l * occlusion_falloff, power));
        occ_color += (c_color * (dot(d, dir) / pow(l * color_falloff, power)));
    }
    occ /= float(rays);
    occ_color /= vec3(float(rays));
    if (occ > 1.0)
    {
        occ = 1.0;
    }
    return vec4(occ_color, occ);
}

vec3 positionFromDepthPrevious(vec3 vDirection, float depth)
{
    return (_201.dispatch_setup.mat_model_previous * vec4(vDirection * depth, 1.0)).xyz;
}

vec4 SampleTextureCatmullRom(sampler2D tex, vec2 uv, vec2 texSize)
{
    vec2 samplePos = uv * texSize;
    vec2 texPos1 = floor(samplePos - vec2(0.5)) + vec2(0.5);
    vec2 f = samplePos - texPos1;
    vec2 w0 = f * (vec2(-0.5) + (f * (vec2(1.0) - (f * 0.5))));
    vec2 w1 = vec2(1.0) + ((f * f) * (vec2(-2.5) + (f * 1.5)));
    vec2 w2 = f * (vec2(0.5) + (f * (vec2(2.0) - (f * 1.5))));
    vec2 w3 = (f * f) * (vec2(-0.5) + (f * 0.5));
    vec2 w12 = w1 + w2;
    vec2 offset12 = w2 / (w1 + w2);
    vec2 texPos0 = texPos1 - vec2(1.0);
    vec2 texPos3 = texPos1 + vec2(2.0);
    vec2 texPos12 = texPos1 + offset12;
    texPos0 /= texSize;
    texPos3 /= texSize;
    texPos12 /= texSize;
    vec4 result = vec4(0.0);
    result += ((textureLod(tex, vec2(texPos0.x, texPos0.y), 0.0) * w0.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos0.y), 0.0) * w12.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos0.y), 0.0) * w3.x) * w0.y);
    result += ((textureLod(tex, vec2(texPos0.x, texPos12.y), 0.0) * w0.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos12.y), 0.0) * w12.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos12.y), 0.0) * w3.x) * w12.y);
    result += ((textureLod(tex, vec2(texPos0.x, texPos3.y), 0.0) * w0.x) * w3.y);
    result += ((textureLod(tex, vec2(texPos12.x, texPos3.y), 0.0) * w12.x) * w3.y);
    result += ((textureLod(tex, vec2(texPos3.x, texPos3.y), 0.0) * w3.x) * w3.y);
    vec4 _1009 = result;
    result.x = _1009.xyz.x;
    result.y = _1009.xyz.y;
    result.z = _1009.xyz.z;
    return result;
}

void main()
{
    float range = min(in_bbox_data.grid_size_voxelize.x, min(in_bbox_data.grid_size_voxelize.y, in_bbox_data.grid_size_voxelize.z));
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    vec3 view_direction;
    float param_7;
    float param_8;
    uint param_9;
    vec3 view_direction_prev;
    for (int i = 0; i < 1; i++)
    {
        ivec2 pos = ivec2((pixel_pos * uvec2(1u)) + _1065[i]);
        ivec2 noise_pos = pos & ivec2(127);
        uint encoded_normal_material = imageLoad(imNormalMaterial, pos).x;
        uint param = encoded_normal_material;
        int materialId = decode_material(param);
        if ((materialId & 1) == 1)
        {
            imageStore(imTarget, pos, vec4(1.0));
        }
        else
        {
            view_direction.x = (-_201.dispatch_setup.camera_projection_params.z) + ((_201.dispatch_setup.camera_projection_params.x * float(pos.x)) * _201.dispatch_setup.inv_resolution.x);
            view_direction.y = (-_201.dispatch_setup.camera_projection_params.w) + ((_201.dispatch_setup.camera_projection_params.y * float(pos.y)) * _201.dispatch_setup.inv_resolution.y);
            view_direction.z = 1.0;
            view_direction.y = -view_direction.y;
            uint encoded_normal_material_1 = imageLoad(imNormalMaterial, pos).x;
            uint param_1 = encoded_normal_material_1;
            vec3 vNorm = decode_normal(param_1);
            uint param_2 = encoded_normal_material_1;
            int materialId_1 = decode_material(param_2);
            float param_3 = texelFetch(sTextureDepth, pos, 0).x;
            float depth = linearizeDepth(param_3);
            vec3 param_4 = view_direction;
            float param_5 = depth;
            vec3 world = positionFromDepth(param_4, param_5);
            uvec2 param_6 = imageLoad(imMetalnessRoughnessMaterialTags, pos).xy;
            decode_metalness_roughness_material(param_6, param_7, param_8, param_9);
            float metalness = param_7;
            float roughness = param_8;
            uint material = param_9;
            vec3 dir = normalize(world - _201.dispatch_setup.camera_position);
            vec4 diffuse = vec4(0.0);
            vec4 specular = vec4(0.0);
            if (_1198.voxel_lighting_setup.compute_diffuse != 0)
            {
                ivec2 param_10 = noise_pos;
                vec3 param_11 = in_bbox_data.grid_size_voxelize.xyz;
                int param_12 = 256;
                vec3 param_13 = in_bbox_data.bbox_voxelize_min.xyz;
                vec3 param_14 = world;
                vec3 param_15 = vNorm;
                vec3 param_16 = vNorm;
                float param_17 = range;
                float param_18 = _1198.voxel_lighting_setup.light_trace_distance_scale;
                float param_19 = min(1.0, 0.550000011920928955078125 + (roughness * 0.25));
                int param_20 = 1;
                float param_21 = _1198.voxel_lighting_setup.light_falloff_factor;
                float param_22 = _1198.voxel_lighting_setup.occlusion_falloff_factor;
                float param_23 = _1198.voxel_lighting_setup.trace_range;
                vec4 _1248 = rt_cone_trace_occlusion(param_10, s_voxel_colors_filtered, s_voxel_occupancy_filtered, param_11, param_12, param_13, param_14, param_15, param_16, param_17, param_18, param_19, param_20, param_21, param_22, param_23);
                diffuse = _1248 * vec4(vec3(1.0 - metalness), 1.0);
            }
            if (_1198.voxel_lighting_setup.compute_specular != 0)
            {
                ivec2 param_24 = noise_pos;
                vec3 param_25 = in_bbox_data.grid_size_voxelize.xyz;
                int param_26 = 256;
                vec3 param_27 = in_bbox_data.bbox_voxelize_min.xyz;
                vec3 param_28 = world;
                vec3 param_29 = vNorm;
                vec3 param_30 = normalize(reflect(world - _201.dispatch_setup.camera_position, vNorm));
                float param_31 = range;
                float param_32 = _1198.voxel_lighting_setup.light_trace_distance_scale;
                float param_33 = roughness;
                int param_34 = 1;
                float param_35 = _1198.voxel_lighting_setup.light_falloff_factor;
                float param_36 = _1198.voxel_lighting_setup.occlusion_falloff_factor;
                float param_37 = _1198.voxel_lighting_setup.trace_range;
                vec4 _1303 = rt_cone_trace_occlusion(param_24, s_voxel_colors_filtered, s_voxel_occupancy_filtered, param_25, param_26, param_27, param_28, param_29, param_30, param_31, param_32, param_33, param_34, param_35, param_36, param_37);
                specular = _1303;
            }
            vec4 occlusion = diffuse;
            vec4 _1308 = occlusion;
            vec3 _1310 = _1308.xyz + specular.xyz;
            occlusion.x = _1310.x;
            occlusion.y = _1310.y;
            occlusion.z = _1310.z;
            float specular_offlusion_contribution = clamp(0.5 - roughness, 0.0, 1.0);
            occlusion.w = (occlusion.w * (1.0 - (specular_offlusion_contribution * 0.5))) + (specular.w * specular_offlusion_contribution);
            if (false)
            {
                vec3 hash = texelFetch(s_BlueNoise, ivec3(noise_pos, 0), 0).xyz;
                occlusion.x = hash.x;
                occlusion.y = hash.y;
                occlusion.z = hash.z;
                occlusion.w = hash.x;
            }
            if (false)
            {
                vec4 view_prev = vec4(world, 1.0);
                view_prev = _201.dispatch_setup.mat_view_previous * view_prev;
                view_prev = _201.dispatch_setup.mat_projection * view_prev;
                vec3 proj_prev = vec3(0.5) + ((view_prev.xyz / vec3(view_prev.w)) * 0.5);
                vec2 screen_prev = proj_prev.xy;
                bool _1385 = screen_prev.x >= 0.0;
                bool _1391;
                if (_1385)
                {
                    _1391 = screen_prev.y >= 0.0;
                }
                else
                {
                    _1391 = _1385;
                }
                bool _1397;
                if (_1391)
                {
                    _1397 = screen_prev.x < 1.0;
                }
                else
                {
                    _1397 = _1391;
                }
                bool _1403;
                if (_1397)
                {
                    _1403 = screen_prev.y < 1.0;
                }
                else
                {
                    _1403 = _1397;
                }
                if (_1403)
                {
                    view_direction_prev.x = (-_201.dispatch_setup.camera_projection_params.z) + (_201.dispatch_setup.camera_projection_params.x * screen_prev.x);
                    view_direction_prev.y = (-_201.dispatch_setup.camera_projection_params.w) + (_201.dispatch_setup.camera_projection_params.y * screen_prev.y);
                    view_direction_prev.z = 1.0;
                    float param_38 = texelFetch(sTextureDepthPrevious, ivec2((proj_prev.xy * _201.dispatch_setup.resolution) + vec2(0.5)), 0).x;
                    float depth_prev = linearizeDepth(param_38);
                    vec3 param_39 = view_direction_prev;
                    float param_40 = depth_prev;
                    vec3 world_prev = positionFromDepthPrevious(param_39, param_40);
                    float tolerance = _1198.voxel_lighting_setup.reprojection_tolerance;
                    if (length(world - world_prev) <= tolerance)
                    {
                        vec2 param_41 = proj_prev.xy + (_201.dispatch_setup.inv_resolution * 0.5);
                        vec2 param_42 = _201.dispatch_setup.resolution;
                        vec4 occlusion_prev = SampleTextureCatmullRom(sTargetPrevious, param_41, param_42);
                        float f = 0.0;
                        occlusion = mix(occlusion_prev, occlusion, vec4(0.300000011920928955078125));
                    }
                }
            }
            imageStore(imTarget, pos, occlusion);
        }
    }
}

 