#version 450

struct CopyRTMaterialPropertyToStencilParams
{
    int scale_denominator;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform CopyRTMaterialPropertyToStencilParamsBuffer
{
    CopyRTMaterialPropertyToStencilParams params;
} _56;

layout(set = 1, binding = 2, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 3, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void main()
{
    ivec2 base_pos = ivec2(gl_FragCoord.xy);
    int is_rt_counter = 0;
    int sample_count = 0;
    if (_56.params.scale_denominator == 1)
    {
        sample_count = 1;
        uvec2 param = imageLoad(imMetalnessRoughnessMaterialTags, base_pos).xy;
        float param_1;
        float param_2;
        uint param_3;
        decode_metalness_roughness_material(param, param_1, param_2, param_3);
        float metalness = param_1;
        float roughness = param_2;
        uint materialIndex = param_3;
        MaterialPropertiesGPU _98;
        _98.diffuse = materials.material_properties[materialIndex].diffuse;
        _98.transparency = materials.material_properties[materialIndex].transparency;
        _98.emissive = materials.material_properties[materialIndex].emissive;
        _98.roughness = materials.material_properties[materialIndex].roughness;
        _98.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
        _98.refraction = materials.material_properties[materialIndex].refraction;
        _98.normal_factor = materials.material_properties[materialIndex].normal_factor;
        _98.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
        _98.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
        _98.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
        _98.metalness = materials.material_properties[materialIndex].metalness;
        _98.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
        _98.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
        _98.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
        _98.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
        _98.flags = materials.material_properties[materialIndex].flags;
        _98._pad0 = materials.material_properties[materialIndex]._pad0;
        _98._pad1 = materials.material_properties[materialIndex]._pad1;
        MaterialPropertiesGPU material = _98;
        bool _104 = (material.flags & 2u) != 0u;
        bool _112;
        if (!_104)
        {
            _112 = (material.flags & 1u) != 0u;
        }
        else
        {
            _112 = _104;
        }
        if (_112)
        {
            is_rt_counter++;
        }
    }
    if (_56.params.scale_denominator == 2)
    {
        sample_count = 4;
        base_pos *= ivec2(2);
        float param_5;
        float param_6;
        uint param_7;
        for (int iy = 0; iy < 2; iy++)
        {
            for (int ix = 0; ix < 2; ix++)
            {
                uvec2 param_4 = imageLoad(imMetalnessRoughnessMaterialTags, base_pos + ivec2(ix, iy)).xy;
                decode_metalness_roughness_material(param_4, param_5, param_6, param_7);
                float metalness_1 = param_5;
                float roughness_1 = param_6;
                uint materialIndex_1 = param_7;
                MaterialPropertiesGPU _166;
                _166.diffuse = materials.material_properties[materialIndex_1].diffuse;
                _166.transparency = materials.material_properties[materialIndex_1].transparency;
                _166.emissive = materials.material_properties[materialIndex_1].emissive;
                _166.roughness = materials.material_properties[materialIndex_1].roughness;
                _166.triplanar_factor = materials.material_properties[materialIndex_1].triplanar_factor;
                _166.refraction = materials.material_properties[materialIndex_1].refraction;
                _166.normal_factor = materials.material_properties[materialIndex_1].normal_factor;
                _166.emissive_factor = materials.material_properties[materialIndex_1].emissive_factor;
                _166.temporal_accumulation_factor = materials.material_properties[materialIndex_1].temporal_accumulation_factor;
                _166.shadowmap_bias = materials.material_properties[materialIndex_1].shadowmap_bias;
                _166.metalness = materials.material_properties[materialIndex_1].metalness;
                _166.albedo_sampler = materials.material_properties[materialIndex_1].albedo_sampler;
                _166.emissive_sampler = materials.material_properties[materialIndex_1].emissive_sampler;
                _166.normal_sampler = materials.material_properties[materialIndex_1].normal_sampler;
                _166.metalic_roughness_sampler = materials.material_properties[materialIndex_1].metalic_roughness_sampler;
                _166.flags = materials.material_properties[materialIndex_1].flags;
                _166._pad0 = materials.material_properties[materialIndex_1]._pad0;
                _166._pad1 = materials.material_properties[materialIndex_1]._pad1;
                MaterialPropertiesGPU material_1 = _166;
                bool _170 = (material_1.flags & 2u) != 0u;
                bool _178;
                if (!_170)
                {
                    _178 = (material_1.flags & 1u) != 0u;
                }
                else
                {
                    _178 = _170;
                }
                if (_178)
                {
                    is_rt_counter++;
                }
            }
        }
    }
    if (is_rt_counter < sample_count)
    {
        discard;
    }
}

 