#version 450

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct RibbonRenderParams
{
    int max_segments;
    int base_idx;
    int base_segment;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct _461
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segments;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _133;

layout(set = 0, binding = 4, std140) uniform RibbonRenderParamsBuffer
{
    RibbonRenderParams ribbon_render_params;
} _395;

layout(set = 0, binding = 5, std140) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 0, binding = 2, std430) buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

layout(set = 0, binding = 3, std430) buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

layout(set = 0, binding = 6, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _834;

layout(set = 0, binding = 7, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 8) uniform sampler2DShadow LightShadowmapCmpSamplers[16];

layout(location = 1) out _461 vtx_output;
layout(location = 0) out uint instanceID;

bool prt_is_alive(uint id)
{
    return _133.prt_states[id].life_time < _133.prt_states[id].life_span;
}

int calculate_vidx_for_ribbon_segment(int ribbon_id, inout int ribbon_segment)
{
    ribbon_segment = _395.ribbon_render_params.base_segment - ribbon_segment;
    if (ribbon_segment < 0)
    {
        ribbon_segment += _395.ribbon_render_params.max_segments;
    }
    if (ribbon_segment >= _395.ribbon_render_params.max_segments)
    {
        ribbon_segment -= _395.ribbon_render_params.max_segments;
    }
    int vidx = ((ribbon_segment * _395.ribbon_render_params.particles_per_segment) + ribbon_id) + _395.ribbon_render_params.base_idx;
    return vidx;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _133.prt_states[id].color;
    vec3 _163 = color_convert_uint_to_float3(param);
    c.x = _163.x;
    c.y = _163.y;
    c.z = _163.z;
    return c;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _151;
    _151.life_time = _133.prt_states[id].life_time;
    _151.life_span = _133.prt_states[id].life_span;
    _151.generation_id = _133.prt_states[id].generation_id;
    _151.color = _133.prt_states[id].color;
    ParticleState _150 = _151;
    return _150;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float sampleShadowPCF(sampler2DShadow smpl, inout vec4 coords, out float in_frustum, int samples, float sampling_range)
{
    float fact = 0.0;
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 1.0;
    }
    bool _186 = coords.x < (-coords.w);
    bool _195;
    if (!_186)
    {
        _195 = coords.x > coords.w;
    }
    else
    {
        _195 = _186;
    }
    bool _205;
    if (!_195)
    {
        _205 = coords.y < (-coords.w);
    }
    else
    {
        _205 = _195;
    }
    bool _214;
    if (!_205)
    {
        _214 = coords.y > coords.w;
    }
    else
    {
        _214 = _205;
    }
    if (_214)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _218 = coords;
    float _224 = coords.w;
    vec2 _226 = (_218.xy * vec2(0.5)) + (vec2(0.5) * _224);
    coords.x = _226.x;
    coords.y = _226.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    float sampling_r = 1.0;
    float _257 = -sampling_r;
    float y = _257;
    int iy = 0;
    for (; iy < samples; iy++, y += ((2.0 * sampling_r) / float(samples - 1)))
    {
        float _269 = -sampling_r;
        float x = _269;
        int ix = 0;
        for (; ix < samples; ix++, x += ((2.0 * sampling_r) / float(samples - 1)))
        {
            vec4 _295 = coords + vec4((x * sampling_range) * coords.w, (y * sampling_range) * coords.w, 0.0, 0.0);
            vec4 _298 = _295;
            _298.z = _295.w;
            float shadow = textureProjLod(smpl, vec4(_298.xy, _295.z, _298.z), 0.0);
            fact += shadow;
        }
    }
    float f = fact * (1.0 / float(samples * samples));
    return f;
}

float light_calculate_spot_attenuation(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position.xyz - pos);
    float falloff = dot(light.direction.xyz, (pos - light.position.xyz) / vec3(light_distance));
    float attenuation = 0.0;
    bool _363 = falloff > cutoff;
    bool _370;
    if (_363)
    {
        _370 = light_distance < light.range;
    }
    else
    {
        _370 = _363;
    }
    if (_370)
    {
        attenuation = 1.0 - ((1.0 - falloff) / (1.0 - cutoff));
        attenuation *= (1.0 - clamp(light_distance / light.range, 0.0, 1.0));
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

vec4 calculate_lighting(inout vec4 color, MaterialPropertiesGPU material)
{
    vec3 light_color = vec3(0.0);
    float param_1;
    for (int light_idx = 0; light_idx < _395.ribbon_render_params.lights_num; light_idx++)
    {
        LightProperties _457;
        _457.diffuse = lights.light_properties[light_idx].diffuse;
        _457.direction = lights.light_properties[light_idx].direction;
        _457.position = lights.light_properties[light_idx].position;
        _457.up = lights.light_properties[light_idx].up;
        _457.right = lights.light_properties[light_idx].right;
        _457.dimensions = lights.light_properties[light_idx].dimensions;
        _457._pad1 = lights.light_properties[light_idx]._pad1;
        _457.intensity = lights.light_properties[light_idx].intensity;
        _457.range = lights.light_properties[light_idx].range;
        _457.cutoff = lights.light_properties[light_idx].cutoff;
        _457.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
        _457.is_area = lights.light_properties[light_idx].is_area;
        _457.type = lights.light_properties[light_idx].type;
        _457.projector_sampler = lights.light_properties[light_idx].projector_sampler;
        _457.projector_intensity = lights.light_properties[light_idx].projector_intensity;
        _457.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
        _457.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
        _457.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
        _457.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
        _457.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
        _457.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
        _457.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
        _457.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
        _457.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
        _457.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
        _457.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
        _457.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
        _457.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
        _457.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
        _457.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
        _457.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
        _457.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
        LightProperties light = _457;
        vec4 projector_color = vec4(0.0);
        vec3 world = vtx_output.vWorldPos;
        float shadow = 0.0;
        bool calculate_shadows = (light.type & 8) != 0;
        if ((material.flags & 512u) == 0u)
        {
            calculate_shadows = false;
        }
        if (((light.type & 3) != 0) && calculate_shadows)
        {
            float penumbra_scaling_factor = 0.5;
            vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
            float in_frustum = 0.0;
            vec4 param = vShadowCoords;
            int param_2 = 3;
            float param_3 = -0.001000000047497451305389404296875;
            float _517 = sampleShadowPCF(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param, param_1, param_2, param_3);
            in_frustum = param_1;
            shadow = _517;
        }
        shadow = 1.0 - shadow;
        if ((light.type & 130) == 130)
        {
            LightProperties param_4 = light;
            vec3 param_5 = world;
            float attenuation = light_calculate_spot_attenuation(param_4, param_5);
            shadow *= attenuation;
        }
        light_color += ((light.diffuse.xyz * sqrt(light.intensity)) * shadow);
    }
    vec4 _552 = color;
    vec3 _554 = _552.xyz * light_color;
    color.x = _554.x;
    color.y = _554.y;
    color.z = _554.z;
    vec4 _563 = color;
    vec3 _565 = _563.xyz * material.diffuse;
    color.x = _565.x;
    color.y = _565.y;
    color.z = _565.z;
    vec4 _577 = color;
    vec3 _579 = _577.xyz + (material.emissive * material.emissive_factor);
    color.x = _579.x;
    color.y = _579.y;
    color.z = _579.z;
    return color;
}

void main()
{
    instanceID = uint(gl_InstanceIndex);
    int odd_even = ((gl_VertexIndex & 1) == 0) ? 1 : (-1);
    int ribbon_id;
    int ribbon_segment;
    if (_395.ribbon_render_params.render_as_strips != 0)
    {
        ribbon_id = gl_InstanceIndex;
        ribbon_segment = gl_VertexIndex / 2;
    }
    else
    {
        uint max_segments_uint = uint(_395.ribbon_render_params.max_segments);
        ribbon_segment = gl_VertexIndex / 2;
        ribbon_id = (gl_InstanceIndex * 64) + int(uint(ribbon_segment) / max_segments_uint);
        ribbon_segment = int(uint(ribbon_segment) % max_segments_uint);
    }
    uint param = uint(ribbon_id);
    if (!prt_is_alive(param))
    {
        gl_Position = vec4(0.0, 0.0, 0.0, -1.0);
        return;
    }
    int ribbon_segments = max(0, (min(_395.ribbon_render_params.max_segments, int(prt_states_snapshots.states[ribbon_id].segments)) - 1));
    ribbon_segment = min(ribbon_segment, ribbon_segments);
    int param_1 = ribbon_id;
    int param_2 = ribbon_segment;
    int _672 = calculate_vidx_for_ribbon_segment(param_1, param_2);
    int vidx = _672;
    vec3 vInstPosition = vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
    vec3 vInstNormal = vec3(1.0, 0.0, 0.0);
    uint param_3 = uint(ribbon_id);
    vec4 vInstColor = prt_get_color(param_3);
    uint param_4 = uint(ribbon_id);
    ParticleState vState = prt_get_state(param_4);
    bool is_last = ribbon_segment >= ribbon_segments;
    bool is_first = ribbon_segment == 0;
    if ((ribbon_segment > 0) || true)
    {
        float shrink_factor = _395.ribbon_render_params.first_segment_time_factor;
        int param_5 = ribbon_id;
        int param_6 = ribbon_segment - 1;
        int _729 = calculate_vidx_for_ribbon_segment(param_5, param_6);
        int next_vidx = _729;
        vec3 nextPosition = vec3(prt_position_snapshots.position[(next_vidx * 3) + 0], prt_position_snapshots.position[(next_vidx * 3) + 1], prt_position_snapshots.position[(next_vidx * 3) + 2]);
        vec3 dir = normalize(cross(-normalize(vInstPosition - nextPosition), vInstNormal)) * 5.0;
        if ((ribbon_segment == ribbon_segments) && (ribbon_segments > 1))
        {
            vInstPosition = mix(vInstPosition, nextPosition, vec3(_395.ribbon_render_params.first_segment_time_factor));
            dir *= 0.100000001490116119384765625;
        }
        if (is_first)
        {
            dir *= (-0.100000001490116119384765625);
        }
        if ((ribbon_segment == 1) && (ribbon_segments > 2))
        {
            dir *= max(0.100000001490116119384765625, shrink_factor);
        }
        if ((ribbon_segment == (ribbon_segments - 1)) && (ribbon_segments > 2))
        {
            dir *= max(0.100000001490116119384765625, 1.0 - shrink_factor);
        }
        if (length(vInstPosition - nextPosition) < 0.001000000047497451305389404296875)
        {
            dir = vec3(1.0, 0.0, 0.0);
        }
        vInstPosition += ((vec3(float(odd_even)) * dir) * _395.ribbon_render_params.thickness);
    }
    vec3 pos = vInstPosition;
    vtx_output.vLocalPos = pos;
    vec3 vPos1 = pos;
    vec3 param_7 = vPos1;
    mat4 param_8 = _834.transform_params.mModelView;
    vec3 vPos = vector_transform_by_mat43(param_7, param_8);
    MaterialPropertiesGPU _854;
    _854.diffuse = materials.material_properties[_395.ribbon_render_params.material_index].diffuse;
    _854.transparency = materials.material_properties[_395.ribbon_render_params.material_index].transparency;
    _854.emissive = materials.material_properties[_395.ribbon_render_params.material_index].emissive;
    _854.roughness = materials.material_properties[_395.ribbon_render_params.material_index].roughness;
    _854.triplanar_factor = materials.material_properties[_395.ribbon_render_params.material_index].triplanar_factor;
    _854.refraction = materials.material_properties[_395.ribbon_render_params.material_index].refraction;
    _854.normal_factor = materials.material_properties[_395.ribbon_render_params.material_index].normal_factor;
    _854.emissive_factor = materials.material_properties[_395.ribbon_render_params.material_index].emissive_factor;
    _854.temporal_accumulation_factor = materials.material_properties[_395.ribbon_render_params.material_index].temporal_accumulation_factor;
    _854.shadowmap_bias = materials.material_properties[_395.ribbon_render_params.material_index].shadowmap_bias;
    _854.metalness = materials.material_properties[_395.ribbon_render_params.material_index].metalness;
    _854.albedo_sampler = materials.material_properties[_395.ribbon_render_params.material_index].albedo_sampler;
    _854.emissive_sampler = materials.material_properties[_395.ribbon_render_params.material_index].emissive_sampler;
    _854.normal_sampler = materials.material_properties[_395.ribbon_render_params.material_index].normal_sampler;
    _854.metalic_roughness_sampler = materials.material_properties[_395.ribbon_render_params.material_index].metalic_roughness_sampler;
    _854.flags = materials.material_properties[_395.ribbon_render_params.material_index].flags;
    _854._pad0 = materials.material_properties[_395.ribbon_render_params.material_index]._pad0;
    _854._pad1 = materials.material_properties[_395.ribbon_render_params.material_index]._pad1;
    MaterialPropertiesGPU material = _854;
    vec3 param_9 = vPos1;
    mat4 param_10 = _834.transform_params.mModel;
    vtx_output.vWorldPos = vector_transform_by_mat43(param_9, param_10);
    vtx_output.vWorldNorm.x = float(vidx);
    vtx_output.vWorldNorm.y = float(ribbon_segment);
    vtx_output.vWorldNorm.z = float(ribbon_id);
    vtx_output.vWorldNorm = vec3(vInstPosition);
    vtx_output.vNorm = vec3(vInstNormal);
    vtx_output.vCoords = vPos;
    vec4 param_11 = vInstColor;
    MaterialPropertiesGPU param_12 = material;
    vec4 _890 = calculate_lighting(param_11, param_12);
    vInstColor = _890;
    float life_time_factor = min(1.0, vState.life_time / vState.life_span);
    life_time_factor = 1.0 - sin((life_time_factor * 3.1415927410125732421875) * 0.5);
    vec4 _908 = vInstColor;
    vec3 _910 = _908.xyz * (1.0 - pow(life_time_factor, 4.0));
    vInstColor.x = _910.x;
    vInstColor.y = _910.y;
    vInstColor.z = _910.z;
    vtx_output.vColor = vec4(vInstColor);
    gl_Position = _834.transform_params.mProjection * vec4(vPos, 1.0);
}

 