#version 450

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec4 direction;
    vec4 position;
    vec4 up;
    vec4 right;
    vec2 dimensions;
    vec2 _pad1;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct link_list_node
{
    uint value;
    uint next;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _75;

layout(set = 0, binding = 2, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _201;

layout(location = 0) out uint instanceID;
layout(location = 1) out Vertex
{
    vec3 vLocalPos;
    vec4 vColor;
    vec2 vUV0;
    uint vIdx;
} vtx_output;


vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_75.in_vtx_data[coord_offset + 0u], _75.in_vtx_data[coord_offset + 1u], _75.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec3 get_vertex(uint idx)
{
    uint param = idx;
    return rt_get_vertex(param);
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 rt_get_vertex_normal(uint idx)
{
    uint normal_offset = (idx * 2u) + 30000000u;
    float param = _75.in_vtx_data[normal_offset + 0u];
    uint n1 = asuint(param);
    float param_1 = _75.in_vtx_data[normal_offset + 1u];
    uint n2 = asuint(param_1);
    vec3 p = vec3(unpackSnorm2x16(n1), unpackSnorm2x16(n2).x);
    return p;
}

vec3 get_vertex_normal(uint idx)
{
    uint param = idx;
    return rt_get_vertex_normal(param);
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

vec4 get_vertex_color(uint idx)
{
    return vec4(1.0, 0.0, 1.0, 1.0);
}

vec2 rt_get_vertex_uv0(uint idx)
{
    uint uv0_offset = (idx * 2u) + 50000000u;
    vec2 p = vec2(_75.in_vtx_data[uv0_offset + 0u], _75.in_vtx_data[uv0_offset + 1u]);
    return p;
}

vec2 get_vertex_uv0(uint idx)
{
    uint param = idx;
    return rt_get_vertex_uv0(param);
}

void main()
{
    instanceID = 0u;
    uint param = uint(gl_VertexIndex);
    vec3 pos = get_vertex(param);
    uint param_1 = uint(gl_VertexIndex);
    vec3 norm = get_vertex_normal(param_1);
    vtx_output.vLocalPos = pos;
    vtx_output.vIdx = uint(gl_VertexIndex);
    vec4 vPos1 = vec4(pos, 1.0);
    vec3 param_2 = pos;
    mat4 param_3 = _201.transform_params.mModelView;
    vec3 vPos = vector_transform_by_mat43(param_2, param_3);
    gl_Position = _201.transform_params.mProjection * vec4(vPos, 1.0);
    uint param_4 = uint(gl_VertexIndex);
    vtx_output.vColor = vec4(get_vertex_color(param_4));
    uint param_5 = uint(gl_VertexIndex);
    vtx_output.vUV0 = vec2(get_vertex_uv0(param_5));
}

 