#version 450
layout(local_size_x = 4, local_size_y = 4, local_size_z = 2) in;

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, rgba8) uniform readonly image3D imSourceColor;
layout(set = 0, binding = 2, r8) uniform readonly image3D imSourceOccupancy;
layout(set = 0, binding = 3, rgba8) uniform writeonly image3D imTarget0Color;
layout(set = 0, binding = 4, r8) uniform writeonly image3D imTarget0Occupancy;
layout(set = 0, binding = 5, rgba8) uniform writeonly image3D imTarget1Color;
layout(set = 0, binding = 6, r8) uniform writeonly image3D imTarget1Occupancy;

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _69 = v;
    float _72 = v.w;
    vec3 _74 = (_69.xyz * _72) * 128.0;
    v.x = _74.x;
    v.y = _74.y;
    v.z = _74.z;
    return v.xyz * v.xyz;
}

vec4 color_convert_rgb_rgbm(inout vec3 v)
{
    v = sqrt(v);
    v /= vec3(128.0);
    vec4 rgbm;
    rgbm.w = clamp(max(max(v.x, v.y), max(v.z, 9.9999999747524270787835121154785e-07)), 0.0, 1.0);
    rgbm.w = ceil(rgbm.w * 256.0) / 255.0;
    float _57 = rgbm.w;
    vec3 _59 = v / vec3(_57);
    rgbm.x = _59.x;
    rgbm.y = _59.y;
    rgbm.z = _59.z;
    return rgbm;
}

void main()
{
    ivec3 grid_pos_16x16x16 = ivec3(gl_WorkGroupID);
    ivec3 grid_pos = (grid_pos_16x16x16 * ivec3(16, 16, 8)) + (ivec3(gl_LocalInvocationID) * ivec3(4));
    int grid_size = int((4u * gl_NumWorkGroups.x) * 4u);
    vec4 cube_samples_mip1[2][2][2];
    for (int iz = 0; iz < 2; iz++)
    {
        for (int iy = 0; iy < 2; iy++)
        {
            for (int ix = 0; ix < 2; ix++)
            {
                cube_samples_mip1[iz][iy][ix] = vec4(0.0);
            }
        }
    }
    ivec3 store_pos = grid_pos;
    vec4 v;
    for (int iz_1 = 0; iz_1 < 4; iz_1++)
    {
        for (int iy_1 = 0; iy_1 < 4; iy_1++)
        {
            for (int ix_1 = 0; ix_1 < 4; ix_1++)
            {
                int source_off = (store_pos.x + (store_pos.y * grid_size)) + ((store_pos.z * grid_size) * grid_size);
                vec4 param = imageLoad(imSourceColor, store_pos);
                vec3 _213 = color_convert_rgbm_rgb(param);
                v.x = _213.x;
                v.y = _213.y;
                v.z = _213.z;
                v.w = imageLoad(imSourceOccupancy, store_pos).x;
                int _229 = iz_1 / 2;
                int _231 = iy_1 / 2;
                int _233 = ix_1 / 2;
                cube_samples_mip1[_229][_231][_233] += v;
                store_pos.x++;
            }
            store_pos.x -= 4;
            store_pos.y++;
        }
        store_pos.y -= 4;
        store_pos.z++;
    }
    vec4 cube_samples_mip2 = vec4(0.0);
    for (int iz_2 = 0; iz_2 < 2; iz_2++)
    {
        for (int iy_2 = 0; iy_2 < 2; iy_2++)
        {
            for (int ix_2 = 0; ix_2 < 2; ix_2++)
            {
                store_pos = (grid_pos / ivec3(2)) + ivec3(ix_2, iy_2, iz_2);
                vec4 samples_color = vec4(0.0);
                samples_color.w = cube_samples_mip1[iz_2][iy_2][ix_2].w;
                if (samples_color.w > 0.0)
                {
                    float _314 = samples_color.w;
                    vec3 _316 = cube_samples_mip1[iz_2][iy_2][ix_2].xyz / vec3(_314);
                    samples_color.x = _316.x;
                    samples_color.y = _316.y;
                    samples_color.z = _316.z;
                }
                samples_color.w *= 0.25;
                vec3 param_1 = samples_color.xyz;
                vec4 _334 = color_convert_rgb_rgbm(param_1);
                imageStore(imTarget0Color, store_pos, _334);
                imageStore(imTarget0Occupancy, store_pos, samples_color.wwww);
                cube_samples_mip2 += samples_color;
            }
        }
    }
    vec4 samples_color_1 = vec4(0.0);
    samples_color_1.w = cube_samples_mip2.w;
    if (samples_color_1.w > 0.0)
    {
        float _361 = samples_color_1.w;
        vec3 _363 = cube_samples_mip2.xyz / vec3(_361);
        samples_color_1.x = _363.x;
        samples_color_1.y = _363.y;
        samples_color_1.z = _363.z;
    }
    samples_color_1.w *= 0.25;
    vec3 param_2 = samples_color_1.xyz;
    vec4 _382 = color_convert_rgb_rgbm(param_2);
    imageStore(imTarget1Color, grid_pos / ivec3(4), _382);
    imageStore(imTarget1Occupancy, grid_pos / ivec3(4), samples_color_1.wwww);
}

 