#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _23;

layout(set = 1, binding = 2, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _54;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    float y = vTexcoord0.y;
    vec2 c = _23.params.resolution * 0.5;
    vec2 dxy = (vTexcoord0 * _23.params.resolution) - c;
    float r = sqrt(dot(dxy, dxy)) / length(_23.params.resolution);
    float d = 0.5 + (0.5 * sin((r * 40.0) + (_54.globals.time * 1.0)));
    r = sqrt(r);
    d *= (r + 0.25);
    float m = fract((vTexcoord0.x / 0.20000000298023223876953125) + (_54.globals.time * 0.300000011920928955078125));
    if (m > 0.5)
    {
        m = 0.5 - (m - 0.5);
    }
    d = smoothstep(0.300000011920928955078125, 0.699999988079071044921875, m * 2.0);
    vec4 base_color = vec4(d, d, d, 1.0);
    outColor = base_color;
}

 