#version 450

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct _49
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _37;

layout(location = 1) in _49 vtx_input;

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return false;
}

void main()
{
    MaterialPropertiesGPU _45;
    _45.diffuse = materials.material_properties[_37.materialIndex].diffuse;
    _45.transparency = materials.material_properties[_37.materialIndex].transparency;
    _45.emissive = materials.material_properties[_37.materialIndex].emissive;
    _45.roughness = materials.material_properties[_37.materialIndex].roughness;
    _45.triplanar_factor = materials.material_properties[_37.materialIndex].triplanar_factor;
    _45.refraction = materials.material_properties[_37.materialIndex].refraction;
    _45.normal_factor = materials.material_properties[_37.materialIndex].normal_factor;
    _45.emissive_factor = materials.material_properties[_37.materialIndex].emissive_factor;
    _45.temporal_accumulation_factor = materials.material_properties[_37.materialIndex].temporal_accumulation_factor;
    _45.shadowmap_bias = materials.material_properties[_37.materialIndex].shadowmap_bias;
    _45.metalness = materials.material_properties[_37.materialIndex].metalness;
    _45.albedo_sampler = materials.material_properties[_37.materialIndex].albedo_sampler;
    _45.emissive_sampler = materials.material_properties[_37.materialIndex].emissive_sampler;
    _45.normal_sampler = materials.material_properties[_37.materialIndex].normal_sampler;
    _45.metalic_roughness_sampler = materials.material_properties[_37.materialIndex].metalic_roughness_sampler;
    _45.flags = materials.material_properties[_37.materialIndex].flags;
    _45._pad0 = materials.material_properties[_37.materialIndex]._pad0;
    _45._pad1 = materials.material_properties[_37.materialIndex]._pad1;
    MaterialPropertiesGPU material = _45;
    MaterialPropertiesGPU param = material;
    vec3 param_1 = vtx_input.vWorldPos;
    vec3 param_2 = vtx_input.vLocalPos;
    vec3 param_3 = vtx_input.vNorm;
    vec3 param_4 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param, param_1, param_2, param_3, param_4);
    if (to_discard)
    {
        discard;
    }
}

 