#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstancingGeneratorParams
{
    float color_lod;
    float occupancy_lod;
    float occupancy_threshold;
    int bbox_from_voxelizer;
    uvec3 resolution;
    int _pad2;
    vec3 bbox_position;
    int _pad3;
    vec3 bbox_dimensions;
    int _pad4;
    vec3 instance_scale_base;
    int _pad7;
    vec3 instance_scale_factor;
    int _pad8;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct link_list_node
{
    uint value;
    uint next;
};

layout(set = 0, binding = 1, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _53;

layout(set = 0, binding = 6, std140) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _74;

layout(set = 0, binding = 2, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_voxelize;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 0, binding = 3, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _292;

layout(set = 0, binding = 4, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _332;

layout(set = 0, binding = 5, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _353;

layout(set = 0, binding = 7) uniform sampler3D s_voxel_colors_filtered;
layout(set = 0, binding = 8) uniform sampler3D s_voxel_occupancy_filtered;

vec3 color_convert_rgbm_rgb(inout vec4 v)
{
    vec4 _15 = v;
    float _21 = v.w;
    vec3 _24 = (_15.xyz * _21) * 128.0;
    v.x = _24.x;
    v.y = _24.y;
    v.z = _24.z;
    return v.xyz * v.xyz;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (_53.instance_params.instance_count >= _53.instance_params.buffer_capacity)
    {
        return;
    }
    uint instance_position_id = id;
    uvec3 instance_position_int;
    instance_position_int.z = instance_position_id / (_74.instancing_generator_params.resolution.x * _74.instancing_generator_params.resolution.y);
    instance_position_id -= (instance_position_int.z * (_74.instancing_generator_params.resolution.x * _74.instancing_generator_params.resolution.y));
    instance_position_int.y = instance_position_id / _74.instancing_generator_params.resolution.x;
    instance_position_id -= (instance_position_int.y * _74.instancing_generator_params.resolution.x);
    instance_position_int.x = instance_position_id;
    vec3 instancing_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 instancing_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    if (_74.instancing_generator_params.bbox_from_voxelizer == 0)
    {
        instancing_bbox_origin = _74.instancing_generator_params.bbox_position;
        instancing_bbox_size = _74.instancing_generator_params.bbox_dimensions;
    }
    vec3 instance_position = ((vec3(instance_position_int) / vec3(_74.instancing_generator_params.resolution)) * instancing_bbox_size) + instancing_bbox_origin;
    vec3 voxelizer_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 voxelizer_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    vec3 source_voxel_position = (instance_position - voxelizer_bbox_origin) / voxelizer_bbox_size;
    bool _167 = source_voxel_position.x < 0.0;
    bool _174;
    if (!_167)
    {
        _174 = source_voxel_position.y < 0.0;
    }
    else
    {
        _174 = _167;
    }
    bool _181;
    if (!_174)
    {
        _181 = source_voxel_position.z < 0.0;
    }
    else
    {
        _181 = _174;
    }
    bool _189;
    if (!_181)
    {
        _189 = source_voxel_position.x >= 1.0;
    }
    else
    {
        _189 = _181;
    }
    bool _196;
    if (!_189)
    {
        _196 = source_voxel_position.y >= 1.0;
    }
    else
    {
        _196 = _189;
    }
    bool _203;
    if (!_196)
    {
        _203 = source_voxel_position.z >= 1.0;
    }
    else
    {
        _203 = _196;
    }
    if (_203)
    {
        return;
    }
    vec4 param = textureLod(s_voxel_colors_filtered, source_voxel_position, _74.instancing_generator_params.color_lod);
    vec3 _219 = color_convert_rgbm_rgb(param);
    vec3 voxel_color = _219;
    float voxel_occupancy = textureLod(s_voxel_occupancy_filtered, source_voxel_position, _74.instancing_generator_params.occupancy_lod).x;
    if (voxel_occupancy <= _74.instancing_generator_params.occupancy_threshold)
    {
        return;
    }
    int _238 = atomicAdd(_53.instance_params.instance_count, 1);
    uint instance_id = uint(_238);
    if (instance_id >= uint(_53.instance_params.buffer_capacity))
    {
        return;
    }
    voxel_occupancy -= _74.instancing_generator_params.occupancy_threshold;
    vec3 instance_scale = _74.instancing_generator_params.instance_scale_base + (_74.instancing_generator_params.instance_scale_factor * (0.25 + (0.75 * voxel_occupancy)));
    voxel_color += vec3(voxel_occupancy * 0.00999999977648258209228515625);
    mat3 transform;
    transform[0] = vec3(instance_scale.x, 0.0, 0.0);
    transform[1] = vec3(0.0, instance_scale.y, 0.0);
    transform[2] = vec3(0.0, 0.0, instance_scale.z);
    transform = transpose(transform);
    _292.instance_transform[(instance_id * 3u) + 0u] = vec4(transform[0], instance_position.x);
    _292.instance_transform[(instance_id * 3u) + 1u] = vec4(transform[1], instance_position.y);
    _292.instance_transform[(instance_id * 3u) + 2u] = vec4(transform[2], instance_position.z);
    _332.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(voxel_color.xy);
    _332.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(vec2(voxel_color.z, 1.0));
    _353.instance_hash[instance_id] = id;
}

 