#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleEmitterGeometry_Params
{
    int constrained;
    int debug_counter;
    int debug_counter2;
    int debug_counter3;
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec4 particle_color;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    float surface_distance;
    int pending;
    int transformed_data_location_idx;
    int transformed_data_location_num;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
    float time_step;
};

struct ParticleModifierSwirl_Params
{
    vec3 position;
    int falloff_curve_idx;
    vec3 radius;
    int falloff_inverse;
    float velocity;
    float velocity_randomness;
    float time_step;
    float axis_randomness;
    vec3 axis;
    float _pad0;
    vec3 scale;
    float _pad1;
};

struct ParticleModifierColorize_Params
{
    int mode;
    int color_gradient_idx;
    float randomness;
    float blend_from_previous;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VM2Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct TransformedDataFace
{
    uint material_idx;
};

struct link_list_node
{
    uint value;
    uint next;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _364;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    vec4 prt_positions[];
} _389;

layout(set = 0, binding = 3, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _794;

layout(set = 0, binding = 4, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _825;

layout(set = 0, binding = 11, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _869;

layout(set = 0, binding = 5, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _935;

layout(set = 0, binding = 6, std430) buffer VM0
{
    ParticleEmitterGeometry_Params VM0_params;
} _1529;

layout(set = 0, binding = 7, std430) buffer VM1
{
    ParticleModifierCurl_Params VM1_params;
} _1558;

layout(set = 0, binding = 12, std140) uniform VM2
{
    VM2Params VM2_params;
} _1574;

layout(set = 0, binding = 8, std430) buffer VM3
{
    ParticleModifierSwirl_Params VM3_params;
} _1596;

layout(set = 0, binding = 9, std430) buffer VM4
{
    ParticleModifierColorize_Params VM4_params;
} _1617;

layout(set = 0, binding = 10, std430) buffer VM5
{
    ParticleModifierCurl_Params VM5_params;
} _1637;

layout(set = 0, binding = 13, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _1651;

layout(set = 0, binding = 14) uniform sampler2D s_Curves;
layout(set = 0, binding = 15) uniform sampler2D s_Gradients;

vec3 prt_get_position(uint id)
{
    return _389.prt_positions[id].xyz;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _370;
    _370.life_time = _364.prt_states[id].life_time;
    _370.life_span = _364.prt_states[id].life_span;
    _370.generation_id = _364.prt_states[id].generation_id;
    _370.color = _364.prt_states[id].color;
    ParticleState _369 = _370;
    return _369;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

uint particle_emitter_geometry_get_first_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _825.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _825.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _347 = hash(param);
    uint param_1 = _347;
    float _349 = floatConstruct(param_1);
    return _349;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_794.in_vtx_data[coord_offset + 0u], _794.in_vtx_data[coord_offset + 1u], _794.in_vtx_data[coord_offset + 2u]);
    return p;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _425 = color_convert_rgb_float3_uint(param);
    uint v = _425;
    state.color = v;
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

void particle_emitter_geometry_emit(ParticleEmitterGeometry_Params emitter_params, inout Particle p, uint id)
{
    ParticleEmitterGeometry_Params param = emitter_params;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    ParticleEmitterGeometry_Params param_1 = emitter_params;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float seed = emitter_params.seed;
    seed += _869.globals.global_time;
    bool emitted = false;
    vec3 bc;
    for (int iteration = 0; iteration < 1; iteration++)
    {
        float fid = float(id + uint(iteration * 45827));
        float fid_seed = ((fid * 0.0131700001657009124755859375) + seed) * 0.00113200000487267971038818359375;
        float param_2 = fid_seed * 5.131999969482421875;
        float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * random(param_2)));
        float param_3 = fid_seed;
        uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_3));
        face_idx += first_face_idx;
        uint p0_idx = _935.transformed_data_indices[(face_idx * 3u) + 0u];
        uint p1_idx = _935.transformed_data_indices[(face_idx * 3u) + 1u];
        uint p2_idx = _935.transformed_data_indices[(face_idx * 3u) + 2u];
        uint param_4 = p0_idx;
        vec3 p0 = rt_get_vertex(param_4);
        uint param_5 = p1_idx;
        vec3 p1 = rt_get_vertex(param_5);
        uint param_6 = p2_idx;
        vec3 p2 = rt_get_vertex(param_6);
        float param_7 = fid_seed * 0.34130001068115234375;
        bc.x = random(param_7);
        float param_8 = fid_seed * 0.1412999927997589111328125;
        bc.y = random(param_8);
        if ((bc.x + bc.y) >= 1.0)
        {
            bc.x = 1.0 - bc.x;
            bc.y = 1.0 - bc.y;
        }
        vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
        float particle_emitter_dist = length((emitter_params.position - pos) / (emitter_params.radius * 0.5));
        if ((emitter_params.constrained == 0) || (particle_emitter_dist <= 1.0))
        {
            if (emitter_params.surface_distance > 0.0)
            {
                vec3 n = normalize(cross(p0 - p1, p0 - p2));
                pos += (n * emitter_params.surface_distance);
            }
            p.pos = pos;
            ParticleState param_9 = p.state;
            vec3 param_10 = emitter_params.particle_color.xyz;
            prt_set_color(param_9, param_10);
            p.state = param_9;
            ParticleState param_11 = p.state;
            float param_12 = lifetime;
            prt_spawn(param_11, param_12);
            p.state = param_11;
            emitted = true;
            break;
        }
    }
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_869.globals.time, _869.globals.time * 0.3014999926090240478515625, (-_869.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1253 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += ((_1253 * modifier_params.noise_strength) * modifier_params.time_step);
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

vec4 quaternion_from_axis_angle(vec3 axis, float angle_in_radians)
{
    vec4 v = vec4((-axis) * sin(angle_in_radians * 0.5), cos(angle_in_radians * 0.5));
    return v;
}

vec3 vector_rotate_by_quaternion(vec3 v, vec4 q)
{
    vec3 u = q.xyz;
    float s = q.w;
    return ((u * (2.0 * dot(u, v))) + (v * ((s * s) - dot(u, u)))) + (cross(u, v) * (2.0 * s));
}

void particle_modifier_swirl(ParticleModifierSwirl_Params modifier_params, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 influence_pos = p.pos;
    float influence = length((influence_pos - modifier_position) / (modifier_params.radius * 0.5));
    if (influence > 1.0)
    {
        influence = 1.0;
    }
    if (modifier_params.falloff_inverse == 0)
    {
        influence = 1.0 - influence;
    }
    influence = 1.0 - influence;
    int param = modifier_params.falloff_curve_idx;
    float param_1 = influence;
    influence = clamp(curve_sample(param, param_1), 0.0, 1.0);
    vec3 axis = modifier_params.axis;
    float param_2 = float(id) * 0.012470000423491001129150390625;
    float randomness_1 = random(param_2);
    float param_3 = float(id) * 0.1031199991703033447265625;
    float randomness_2 = random(param_3);
    axis.x += (randomness_1 * modifier_params.axis_randomness);
    axis.y -= (randomness_1 * modifier_params.axis_randomness);
    axis.z += (randomness_2 * modifier_params.axis_randomness);
    axis = normalize(axis);
    float angle_rad = modifier_params.velocity * (1.0 + (randomness_1 * modifier_params.velocity_randomness));
    angle_rad *= (modifier_params.time_step * influence);
    vec3 param_4 = axis;
    float param_5 = angle_rad;
    vec4 q = quaternion_from_axis_angle(param_4, param_5);
    vec3 pos = p.pos - modifier_params.position;
    vec3 param_6 = pos;
    vec4 param_7 = q;
    pos = vector_rotate_by_quaternion(param_6, param_7);
    vec3 pos_scaled = pos * modifier_params.scale;
    pos = mix(pos, pos_scaled, vec3(modifier_params.time_step * influence));
    pos += modifier_params.position;
    p.pos = pos;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(ParticleState state)
{
    vec4 c = vec4(1.0);
    uint param = state.color;
    vec3 _412 = color_convert_uint_to_float3(param);
    c.x = _412.x;
    c.y = _412.y;
    c.z = _412.z;
    return c;
}

void particle_modifier_colorize(ParticleModifierColorize_Params modifier_params, inout Particle p, uint id)
{
    if (modifier_params.color_gradient_idx == (-1))
    {
        return;
    }
    float v = 0.0;
    if (modifier_params.mode == 0)
    {
        v = float(id) * modifier_params.randomness;
    }
    if (modifier_params.mode == 1)
    {
        vec3 param = p.pos * modifier_params.randomness;
        v = snoise(param);
    }
    if (modifier_params.mode == 2)
    {
        if (p.state.life_time == 0.0)
        {
            vec3 param_1 = p.pos * modifier_params.randomness;
            v = snoise(param_1);
        }
        else
        {
            return;
        }
    }
    v = fract(v);
    int param_2 = modifier_params.color_gradient_idx;
    float param_3 = v;
    vec3 color = gradient_sample(param_2, param_3).xyz;
    ParticleState param_4 = p.state;
    vec4 color_previous = prt_get_color(param_4);
    color = mix(color_previous.xyz, color, vec3(modifier_params.blend_from_previous));
    ParticleState param_5 = p.state;
    vec3 param_6 = color;
    prt_set_color(param_5, param_6);
    p.state = param_5;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _377;
    _377.life_time = state.life_time;
    _377.life_span = state.life_span;
    _377.generation_id = state.generation_id;
    _377.color = state.color;
    _364.prt_states[id] = _377;
}

void prt_set_position(uint id, vec3 p)
{
    _389.prt_positions[id].x = p.x;
    _389.prt_positions[id].y = p.y;
    _389.prt_positions[id].z = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    ParticleState param_2 = p.state;
    if (!prt_is_alive(param_2))
    {
        int _1533 = atomicAdd(_1529.VM0_params.pending, -1);
        int pending = _1533;
        if (pending > 0)
        {
            ParticleEmitterGeometry_Params _1542;
            _1542.constrained = _1529.VM0_params.constrained;
            _1542.debug_counter = _1529.VM0_params.debug_counter;
            _1542.debug_counter2 = _1529.VM0_params.debug_counter2;
            _1542.debug_counter3 = _1529.VM0_params.debug_counter3;
            _1542.position = _1529.VM0_params.position;
            _1542.falloff_mode = _1529.VM0_params.falloff_mode;
            _1542.radius = _1529.VM0_params.radius;
            _1542.falloff_inverse = _1529.VM0_params.falloff_inverse;
            _1542.particle_color = _1529.VM0_params.particle_color;
            _1542.particle_lifetime = _1529.VM0_params.particle_lifetime;
            _1542.particle_lifetime_randomness = _1529.VM0_params.particle_lifetime_randomness;
            _1542.rate = _1529.VM0_params.rate;
            _1542.seed = _1529.VM0_params.seed;
            _1542.surface_distance = _1529.VM0_params.surface_distance;
            _1542.pending = _1529.VM0_params.pending;
            _1542.transformed_data_location_idx = _1529.VM0_params.transformed_data_location_idx;
            _1542.transformed_data_location_num = _1529.VM0_params.transformed_data_location_num;
            ParticleEmitterGeometry_Params param_3 = _1542;
            Particle param_4 = p;
            uint param_5 = id;
            particle_emitter_geometry_emit(param_3, param_4, param_5);
            p = param_4;
        }
    }
    ParticleState param_6 = p.state;
    if (prt_is_alive(param_6))
    {
        ParticleModifierCurl_Params _1563;
        _1563.position = _1558.VM1_params.position;
        _1563.falloff_mode = _1558.VM1_params.falloff_mode;
        _1563.radius = _1558.VM1_params.radius;
        _1563.falloff_inverse = _1558.VM1_params.falloff_inverse;
        _1563.noise_strength = _1558.VM1_params.noise_strength;
        _1563.noise_speed = _1558.VM1_params.noise_speed;
        _1563.noise_scale = _1558.VM1_params.noise_scale;
        _1563.time_step = _1558.VM1_params.time_step;
        ParticleModifierCurl_Params param_7 = _1563;
        Particle param_8 = p;
        uint param_9 = id;
        particle_modifier_curl(param_7, param_8, param_9);
        p = param_8;
    }
    vec3 modifier_position = _1574.VM2_params.position;
    p.pos += (_1574.VM2_params.velocity * _1574.VM2_params.time_step);
    ParticleState param_10 = p.state;
    if (prt_is_alive(param_10))
    {
        ParticleModifierSwirl_Params _1601;
        _1601.position = _1596.VM3_params.position;
        _1601.falloff_curve_idx = _1596.VM3_params.falloff_curve_idx;
        _1601.radius = _1596.VM3_params.radius;
        _1601.falloff_inverse = _1596.VM3_params.falloff_inverse;
        _1601.velocity = _1596.VM3_params.velocity;
        _1601.velocity_randomness = _1596.VM3_params.velocity_randomness;
        _1601.time_step = _1596.VM3_params.time_step;
        _1601.axis_randomness = _1596.VM3_params.axis_randomness;
        _1601.axis = _1596.VM3_params.axis;
        _1601._pad0 = _1596.VM3_params._pad0;
        _1601.scale = _1596.VM3_params.scale;
        _1601._pad1 = _1596.VM3_params._pad1;
        ParticleModifierSwirl_Params param_11 = _1601;
        Particle param_12 = p;
        uint param_13 = id;
        particle_modifier_swirl(param_11, param_12, param_13);
        p = param_12;
    }
    ParticleState param_14 = p.state;
    if (prt_is_alive(param_14))
    {
        ParticleModifierColorize_Params _1622;
        _1622.mode = _1617.VM4_params.mode;
        _1622.color_gradient_idx = _1617.VM4_params.color_gradient_idx;
        _1622.randomness = _1617.VM4_params.randomness;
        _1622.blend_from_previous = _1617.VM4_params.blend_from_previous;
        ParticleModifierColorize_Params param_15 = _1622;
        Particle param_16 = p;
        uint param_17 = id;
        particle_modifier_colorize(param_15, param_16, param_17);
        p = param_16;
    }
    ParticleState param_18 = p.state;
    if (prt_is_alive(param_18))
    {
        ParticleModifierCurl_Params _1641;
        _1641.position = _1637.VM5_params.position;
        _1641.falloff_mode = _1637.VM5_params.falloff_mode;
        _1641.radius = _1637.VM5_params.radius;
        _1641.falloff_inverse = _1637.VM5_params.falloff_inverse;
        _1641.noise_strength = _1637.VM5_params.noise_strength;
        _1641.noise_speed = _1637.VM5_params.noise_speed;
        _1641.noise_scale = _1637.VM5_params.noise_scale;
        _1641.time_step = _1637.VM5_params.time_step;
        ParticleModifierCurl_Params param_19 = _1641;
        Particle param_20 = p;
        uint param_21 = id;
        particle_modifier_curl(param_19, param_20, param_21);
        p = param_20;
    }
    ParticleState param_22 = p.state;
    float param_23 = _1651.lifecycle_params.time_step;
    float param_24 = _1651.lifecycle_params.max_lifetime;
    prt_advance_life(param_22, param_23, param_24);
    p.state = param_22;
    uint param_25 = id;
    ParticleState param_26 = p.state;
    prt_set_state(param_25, param_26);
    uint param_27 = id;
    vec3 param_28 = p.pos;
    prt_set_position(param_27, param_28);
}

 