#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct TextureResourceParams
{
    int flip_y;
    int clamp_range_01;
    float remap_range_start;
    float remap_range_end;
};

struct TextureProcessParams
{
    int width;
    int height;
    float width_inv;
    float height_inv;
    float param1;
    float param2;
    float param3;
    float param4;
    vec4 param_color;
    TextureResourceParams txt_params;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform TextureProcessParamsBuffer
{
    TextureProcessParams texture_process_params;
} _98;

layout(set = 0, binding = 3) uniform sampler2D sSource;
layout(set = 0, binding = 2, r16f) uniform writeonly image2D imDest;

vec4 texture_sample_lod_with_params(sampler2D smp, inout vec2 uv, float lod, TextureResourceParams params)
{
    if (params.flip_y != 0)
    {
        uv.y = 1.0 - uv.y;
    }
    vec4 v = textureLod(smp, uv, lod);
    v = (v - vec4(params.remap_range_start)) / vec4(params.remap_range_end - params.remap_range_start);
    if (params.clamp_range_01 != 0)
    {
        v = clamp(v, vec4(0.0), vec4(1.0));
    }
    return v;
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    vec2 texel_pos = vec2(pixel_pos) * vec2(_98.texture_process_params.width_inv, _98.texture_process_params.height_inv);
    texel_pos = floor(texel_pos * 256.0) / vec2(256.0);
    float r = length(texel_pos - vec2(0.5));
    vec2 param = texel_pos;
    float param_1 = 0.0;
    TextureResourceParams _128;
    _128.flip_y = _98.texture_process_params.txt_params.flip_y;
    _128.clamp_range_01 = _98.texture_process_params.txt_params.clamp_range_01;
    _128.remap_range_start = _98.texture_process_params.txt_params.remap_range_start;
    _128.remap_range_end = _98.texture_process_params.txt_params.remap_range_end;
    TextureResourceParams param_2 = _128;
    vec4 _129 = texture_sample_lod_with_params(sSource, param, param_1, param_2);
    float depth = _129.x;
    float depth_bias = _98.texture_process_params.param2 / 100.0;
    float v = 0.0;
    for (int iy = -2; iy <= 2; iy++)
    {
        for (int ix = -2; ix <= 2; ix++)
        {
            vec2 param_3 = texel_pos + (vec2(float(ix), float(iy)) * 0.004999999888241291046142578125);
            float param_4 = 0.0;
            TextureResourceParams _171;
            _171.flip_y = _98.texture_process_params.txt_params.flip_y;
            _171.clamp_range_01 = _98.texture_process_params.txt_params.clamp_range_01;
            _171.remap_range_start = _98.texture_process_params.txt_params.remap_range_start;
            _171.remap_range_end = _98.texture_process_params.txt_params.remap_range_end;
            TextureResourceParams param_5 = _171;
            vec4 _172 = texture_sample_lod_with_params(sSource, param_3, param_4, param_5);
            float vd = _172.x;
            v += vd;
        }
    }
    v /= 25.0;
    v -= depth_bias;
    r += ((_98.texture_process_params.param1 / 25.0) - 2.0);
    v -= r;
    v = clamp(v, 0.0, 1.0);
    imageStore(imDest, ivec2(pixel_pos), vec4(v));
}

 