#version 450

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct InstancedMeshParams
{
    float scale;
    int merged_clones;
    int base_verts_num;
};

struct _370
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _102;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    vec4 prt_positions[];
} _117;

layout(set = 0, binding = 3, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 4, std430) buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 5, std140) uniform InstancedMeshParamsBuffer
{
    InstancedMeshParams instanced_mesh_params;
} _197;

layout(set = 0, binding = 6, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _382;

layout(location = 0) out uint instanceID;
layout(location = 1) out _370 vtx_output;

vec3 prt_get_position(uint id)
{
    return _117.prt_positions[id].xyz;
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _102.prt_states[id].color;
    vec3 _134 = color_convert_uint_to_float3(param);
    c.x = _134.x;
    c.y = _134.y;
    c.z = _134.z;
    return c;
}

bool prt_is_alive(uint id)
{
    return _102.prt_states[id].life_time < _102.prt_states[id].life_span;
}

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec3 vtx_normals_load(uint idx)
{
    return vec3(vtx_normals.normals[(idx * 3u) + 0u], vtx_normals.normals[(idx * 3u) + 1u], vtx_normals.normals[(idx * 3u) + 2u]);
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

void main()
{
    int instance_idx = (gl_InstanceIndex * _197.instanced_mesh_params.merged_clones) + (gl_VertexIndex / _197.instanced_mesh_params.base_verts_num);
    uint param = uint(instance_idx);
    vec3 vInstPosition = prt_get_position(param);
    uint param_1 = uint(instance_idx);
    vec4 vInstColor = prt_get_color(param_1);
    uint param_2 = uint(instance_idx);
    bool is_alive = prt_is_alive(param_2);
    instanceID = uint(gl_InstanceIndex);
    vec3 angles = vec3(0.0);
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    uint param_3 = uint(gl_VertexIndex);
    vec3 cube_coords = vtx_coords_load(param_3);
    uint param_4 = uint(gl_VertexIndex);
    vec3 cube_normal = vtx_normals_load(param_4);
    float _328;
    if (is_alive)
    {
        _328 = _197.instanced_mesh_params.scale;
    }
    else
    {
        _328 = 0.0;
    }
    float cube_scale = _328;
    cube_coords = vec3(dot(cube_coords, mx), dot(cube_coords, my), dot(cube_coords, mz));
    cube_normal = vec3(dot(cube_normal, mx), dot(cube_normal, my), dot(cube_normal, mz));
    vInstPosition += (cube_coords * cube_scale);
    vec3 pos = vInstPosition;
    vec3 norm = vec3(cube_normal);
    vtx_output.vLocalPos = pos;
    vec3 vPos1 = pos;
    vec3 param_5 = vPos1;
    mat4 param_6 = _382.transform_params.mModelView;
    vec3 vPos = vector_transform_by_mat43(param_5, param_6);
    vec3 param_7 = vPos1;
    mat4 param_8 = _382.transform_params.mModel;
    vtx_output.vWorldPos = vector_transform_by_mat43(param_7, param_8);
    vtx_output.vWorldNorm = norm;
    vtx_output.vNorm = norm;
    vtx_output.vCoords = vPos;
    vtx_output.vColor = vec4(vInstColor);
    vtx_output.vUV0 = vec2(0.0);
    gl_Position = _382.transform_params.mProjection * vec4(vPos, 1.0);
}

 