#version 450

struct TextureResourceParams
{
    int flip_y;
    int clamp_range_01;
    float remap_range_start;
    float remap_range_end;
};

struct VertexModifierTextureDisplaceParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    vec3 value_scale;
    float value_base;
    vec3 scale;
    int falloff_inverse;
    vec3 position;
    int displacement_mode;
    vec3 radius;
    int value_absolute;
    int falloff_curve_idx;
    int material_id;
    int radial;
    int smooth_displacement;
    int mapping_plane;
    int _pad0;
    int _pad1;
    int _pad2;
    TextureResourceParams source_txt_params;
};

struct VertexInput
{
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

const int _291[5] = int[](-2, -1, 0, 1, 2);
const float _313[5] = float[](0.0625, 0.25, 0.375, 0.25, 0.0625);

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct _1202
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) buffer VTXNormals
{
    float normals[];
} vtx_normals;

layout(set = 0, binding = 3, std430) buffer VTXAlbedo
{
    float albedo[];
} vtx_albedo;

layout(set = 0, binding = 4, std430) buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 7, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _395;

layout(set = 0, binding = 8, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 9, std140) uniform GeometryInformationBuffer
{
    GeometryInformation geometry_information;
} _1011;

layout(set = 0, binding = 10, std140) uniform VM0
{
    layout(row_major) VertexModifierTextureDisplaceParams VM0_params;
} _1058;

layout(set = 0, binding = 11, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1071;

layout(set = 0, binding = 5, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1082;

layout(set = 0, binding = 6, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1164;

layout(set = 0, binding = 12) uniform sampler2D s_Curves;
layout(set = 0, binding = 13) uniform sampler2D material_textures[64];

layout(location = 0) out uint instanceID;
layout(location = 1) out _1202 vtx_output;

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec3 vtx_albedo_load(uint idx)
{
    return vec3(vtx_albedo.albedo[(idx * 3u) + 0u], vtx_albedo.albedo[(idx * 3u) + 1u], vtx_albedo.albedo[(idx * 3u) + 2u]);
}

vec3 vtx_normals_load(uint idx)
{
    return vec3(vtx_normals.normals[(idx * 3u) + 0u], vtx_normals.normals[(idx * 3u) + 1u], vtx_normals.normals[(idx * 3u) + 2u]);
}

vec2 vtx_uv0_load(uint idx)
{
    return vec2(vtx_uv0.uv0[(idx * 2u) + 0u], vtx_uv0.uv0[(idx * 2u) + 1u]);
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

vec4 texture_sample_lod_with_params(sampler2D smp, inout vec2 uv, float lod, TextureResourceParams params)
{
    if (params.flip_y != 0)
    {
        uv.y = 1.0 - uv.y;
    }
    vec4 v = textureLod(smp, uv, lod);
    v = (v - vec4(params.remap_range_start)) / vec4(params.remap_range_end - params.remap_range_start);
    if (params.clamp_range_01 != 0)
    {
        v = clamp(v, vec4(0.0), vec4(1.0));
    }
    return v;
}

float vertex_modifier_texture_displace_sample_texture_avg(sampler2D t, vec2 p, float lod, inout float d, TextureResourceParams t_params)
{
    float t_w = 0.0;
    float v = 0.0;
    ivec2 t_size = textureSize(t, int(lod));
    d = 1.0 / float(t_size.x);
    for (int y = 0; y < 5; y++)
    {
        for (int x = 0; x < 5; x++)
        {
            vec2 dp = (vec2(float(_291[x]), float(_291[y])) * d) * 1.5;
            float w = _313[x] * _313[y];
            vec2 param = p + dp;
            float param_1 = lod;
            TextureResourceParams param_2 = t_params;
            vec4 _332 = texture_sample_lod_with_params(t, param, param_1, param_2);
            v += (_332.x * w);
            t_w += w;
        }
    }
    return v / t_w;
}

float vertex_modifier_texture_displace_sample_texture(sampler2D t, vec2 p, float lod, float d, bool smooth_displacement, TextureResourceParams t_params)
{
    if (smooth_displacement)
    {
        vec2 param = p;
        float param_1 = lod;
        float param_2 = d;
        TextureResourceParams param_3 = t_params;
        float _361 = vertex_modifier_texture_displace_sample_texture_avg(t, param, param_1, param_2, param_3);
        return _361;
    }
    else
    {
        vec2 param_4 = p;
        float param_5 = lod;
        TextureResourceParams param_6 = t_params;
        vec4 _370 = texture_sample_lod_with_params(t, param_4, param_5, param_6);
        return _370.x;
    }
}

void vertex_modifier_texture_displace_apply(VertexModifierTextureDisplaceParams params, inout VertexInput vtx_input)
{
    if (params.material_id == 0)
    {
        return;
    }
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx_input.pos;
    vec3 param = vtx_input.pos;
    mat4 param_1 = (params.transform_parent_inv * params.transform_local_inv) * _395.transform_params.mModel;
    vec3 influence_pos = vector_transform_by_mat43(param, param_1);
    vec3 texture_sample_pos = influence_pos;
    vec3 rel_coords = base_pos;
    vec3 influence_rel_coords = influence_pos;
    float influence = length((influence_rel_coords - modifier_position) / params.radius);
    if (influence <= 1.0)
    {
        MaterialPropertiesGPU _438;
        _438.diffuse = materials.material_properties[params.material_id].diffuse;
        _438.transparency = materials.material_properties[params.material_id].transparency;
        _438.emissive = materials.material_properties[params.material_id].emissive;
        _438.roughness = materials.material_properties[params.material_id].roughness;
        _438.triplanar_factor = materials.material_properties[params.material_id].triplanar_factor;
        _438.refraction = materials.material_properties[params.material_id].refraction;
        _438.normal_factor = materials.material_properties[params.material_id].normal_factor;
        _438.emissive_factor = materials.material_properties[params.material_id].emissive_factor;
        _438.temporal_accumulation_factor = materials.material_properties[params.material_id].temporal_accumulation_factor;
        _438.shadowmap_bias = materials.material_properties[params.material_id].shadowmap_bias;
        _438.metalness = materials.material_properties[params.material_id].metalness;
        _438.albedo_sampler = materials.material_properties[params.material_id].albedo_sampler;
        _438.emissive_sampler = materials.material_properties[params.material_id].emissive_sampler;
        _438.normal_sampler = materials.material_properties[params.material_id].normal_sampler;
        _438.metalic_roughness_sampler = materials.material_properties[params.material_id].metalic_roughness_sampler;
        _438.flags = materials.material_properties[params.material_id].flags;
        _438._pad0 = materials.material_properties[params.material_id]._pad0;
        _438._pad1 = materials.material_properties[params.material_id]._pad1;
        MaterialPropertiesGPU material = _438;
        if (material.albedo_sampler == (-1))
        {
            return;
        }
        if (params.falloff_inverse == 0)
        {
            influence = 1.0 - influence;
        }
        int param_2 = params.falloff_curve_idx;
        float param_3 = 1.0 - influence;
        influence = curve_sample(param_2, param_3);
        float lod = 0.0;
        float d_texel = 1.0 / float(textureSize(material_textures[material.albedo_sampler], int(lod)).x);
        vec2 d_gradient = vec2(0.02500000037252902984619140625);
        vec2 tpos = vec2(0.0);
        vec3 tpos_offset_x = vec3(0.0);
        vec3 tpos_offset_y = vec3(0.0);
        if (params.mapping_plane == 0)
        {
            d_gradient = (params.radius.yz * d_texel) / (params.scale.xy / vec2(2.0));
            tpos = texture_sample_pos.yz / (params.radius.yz * 2.0);
            tpos_offset_x = vec3(0.0, d_gradient.x, 0.0);
            tpos_offset_y = vec3(0.0, 0.0, d_gradient.y);
        }
        else
        {
            if (params.mapping_plane == 1)
            {
                d_gradient = (params.radius.xz * d_texel) / (params.scale.xy / vec2(2.0));
                tpos = texture_sample_pos.xz / (params.radius.xz * 2.0);
                tpos_offset_x = vec3(d_gradient.x, 0.0, 0.0);
                tpos_offset_y = vec3(0.0, 0.0, d_gradient.y);
            }
            else
            {
                d_gradient = (params.radius.xy * d_texel) / (params.scale.xy / vec2(2.0));
                tpos = texture_sample_pos.xy / (params.radius.xy * 2.0);
                tpos_offset_x = vec3(d_gradient.x, 0.0, 0.0);
                tpos_offset_y = vec3(0.0, d_gradient.y, 0.0);
            }
        }
        if (params.radial != 0)
        {
            float r = length(fract(abs(tpos)) - vec2(0.5));
            vec2 t = fract(tpos) - vec2(0.5);
            if (abs(t.y) < 9.9999997473787516355514526367188e-06)
            {
                t.y = 9.9999997473787516355514526367188e-06;
            }
            tpos.x = 1.0 - (abs((atan(t.y, t.x) / 3.1415927410125732421875) + 1.0) * 0.5);
            tpos.y = r * 2.0;
            tpos *= params.scale.xy;
        }
        else
        {
            tpos *= params.scale.xy;
            tpos -= vec2(0.5);
            tpos.y = 1.0 - tpos.y;
        }
        tpos.y = 1.0 - tpos.y;
        vec2 param_4 = tpos + vec2(-d_texel, 0.0);
        float param_5 = lod;
        float param_6 = d_texel;
        bool param_7 = params.smooth_displacement != 0;
        TextureResourceParams param_8 = params.source_txt_params;
        float b_x = vertex_modifier_texture_displace_sample_texture(material_textures[material.albedo_sampler], param_4, param_5, param_6, param_7, param_8);
        vec2 param_9 = tpos + vec2(0.0, d_texel);
        float param_10 = lod;
        float param_11 = d_texel;
        bool param_12 = params.smooth_displacement != 0;
        TextureResourceParams param_13 = params.source_txt_params;
        float b_y = vertex_modifier_texture_displace_sample_texture(material_textures[material.albedo_sampler], param_9, param_10, param_11, param_12, param_13);
        vec2 param_14 = tpos;
        float param_15 = lod;
        float param_16 = d_texel;
        bool param_17 = params.smooth_displacement != 0;
        TextureResourceParams param_18 = params.source_txt_params;
        float b = vertex_modifier_texture_displace_sample_texture(material_textures[material.albedo_sampler], param_14, param_15, param_16, param_17, param_18);
        float n = params.value_base + b;
        float n_dx = params.value_base + b_x;
        float n_dy = params.value_base + b_y;
        if (params.value_absolute != 0)
        {
            n = abs(n);
            n_dx = abs(n_dx);
            n_dy = abs(n_dy);
        }
        float scale = params.value_scale.z;
        vec3 local_norm = vtx_input.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_19 = modifier_position;
            mat4 param_20 = params.transform_local;
            local_norm = normalize(base_pos - vector_transform_by_mat43(param_19, param_20));
        }
        vec3 new_pos = base_pos + ((local_norm * n) * scale);
        vec3 new_pos_dx = (base_pos + tpos_offset_x) + ((local_norm * n_dx) * scale);
        vec3 new_pos_dy = (base_pos + tpos_offset_y) + ((local_norm * n_dy) * scale);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        new_pos_dx = mix(base_pos + tpos_offset_x, new_pos_dx, vec3(influence));
        new_pos_dy = mix(base_pos + tpos_offset_y, new_pos_dy, vec3(influence));
        vec3 dx;
        vec3 dy;
        if (params.mapping_plane == 0)
        {
            dx = vec3(((n_dx - n) * influence) * scale, d_gradient.x, 0.0);
            dy = vec3(((n_dy - n) * influence) * scale, 0.0, d_gradient.y);
        }
        else
        {
            if (params.mapping_plane == 1)
            {
                dx = vec3(d_gradient.x, ((-(n_dx - n)) * influence) * scale, 0.0);
                dy = vec3(0.0, ((-(n_dy - n)) * influence) * scale, d_gradient.y);
            }
            else
            {
                dx = vec3(d_gradient.x, 0.0, ((n_dx - n) * influence) * scale);
                dy = vec3(0.0, d_gradient.y, ((n_dy - n) * influence) * scale);
            }
        }
        vec3 new_norm = vec3(1.0);
        dx = normalize(dx);
        dy = normalize(dy);
        vec3 dz = cross(dx, dy);
        dx = cross(dz, dy);
        mat3 m;
        m[0] = vec3(dx.x, dy.x, dz.x);
        m[1] = vec3(dx.y, dy.y, dz.y);
        m[2] = vec3(dx.z, dy.z, dz.z);
        if (params.mapping_plane == 0)
        {
            new_norm = mat3(vec3(dx), vec3(dy), vec3(dz)) * vtx_input.norm;
        }
        else
        {
            if (params.mapping_plane == 1)
            {
                mat3 _956 = mat3(vec3(dx), vec3(dz), vec3(dy));
                new_norm = mat3(-_956[0], -_956[1], -_956[2]) * vtx_input.norm;
            }
            else
            {
                new_norm = mat3(vec3(dx), vec3(dy), vec3(dz)) * vtx_input.norm;
            }
        }
        vtx_input.pos = new_pos;
        vtx_input.norm = normalize(new_norm);
    }
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

void main()
{
    uint param = uint(gl_VertexIndex);
    VertexInput vtx_input;
    vtx_input.pos = vtx_coords_load(param);
    vtx_input.norm = vec3(1.0, 0.0, 0.0);
    vtx_input.color = vec4(1.0);
    vtx_input.uv0 = vtx_input.pos.xy;
    if ((_1011.geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = uint(gl_VertexIndex);
        vtx_input.color = vec4(vtx_albedo_load(param_1), 1.0);
    }
    if ((_1011.geometry_information.builtin_attribute_mask & 2u) != 0u)
    {
        uint param_2 = uint(gl_VertexIndex);
        vtx_input.norm = vtx_normals_load(param_2);
    }
    if ((_1011.geometry_information.builtin_attribute_mask & 8u) != 0u)
    {
        uint param_3 = uint(gl_VertexIndex);
        vtx_input.uv0 = vtx_uv0_load(param_3);
    }
    VertexInput vtx_modifier_input_base = vtx_input;
    VertexModifierTextureDisplaceParams _1063;
    _1063.transform_world_to_local = _1058.VM0_params.transform_world_to_local;
    _1063.transform_local_to_world = _1058.VM0_params.transform_local_to_world;
    _1063.transform_local = _1058.VM0_params.transform_local;
    _1063.transform_local_inv = _1058.VM0_params.transform_local_inv;
    _1063.transform_parent = _1058.VM0_params.transform_parent;
    _1063.transform_parent_inv = _1058.VM0_params.transform_parent_inv;
    _1063.value_scale = _1058.VM0_params.value_scale;
    _1063.value_base = _1058.VM0_params.value_base;
    _1063.scale = _1058.VM0_params.scale;
    _1063.falloff_inverse = _1058.VM0_params.falloff_inverse;
    _1063.position = _1058.VM0_params.position;
    _1063.displacement_mode = _1058.VM0_params.displacement_mode;
    _1063.radius = _1058.VM0_params.radius;
    _1063.value_absolute = _1058.VM0_params.value_absolute;
    _1063.falloff_curve_idx = _1058.VM0_params.falloff_curve_idx;
    _1063.material_id = _1058.VM0_params.material_id;
    _1063.radial = _1058.VM0_params.radial;
    _1063.smooth_displacement = _1058.VM0_params.smooth_displacement;
    _1063.mapping_plane = _1058.VM0_params.mapping_plane;
    _1063._pad0 = _1058.VM0_params._pad0;
    _1063._pad1 = _1058.VM0_params._pad1;
    _1063._pad2 = _1058.VM0_params._pad2;
    _1063.source_txt_params.flip_y = _1058.VM0_params.source_txt_params.flip_y;
    _1063.source_txt_params.clamp_range_01 = _1058.VM0_params.source_txt_params.clamp_range_01;
    _1063.source_txt_params.remap_range_start = _1058.VM0_params.source_txt_params.remap_range_start;
    _1063.source_txt_params.remap_range_end = _1058.VM0_params.source_txt_params.remap_range_end;
    VertexModifierTextureDisplaceParams param_4 = _1063;
    VertexInput param_5 = vtx_input;
    vertex_modifier_texture_displace_apply(param_4, param_5);
    vtx_input = param_5;
    if (_1071.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1082.instance_transform[(gl_InstanceIndex * _1071.instance_params.stride) + 0];
        vec4 inst_m1 = _1082.instance_transform[(gl_InstanceIndex * _1071.instance_params.stride) + 1];
        vec4 inst_m2 = _1082.instance_transform[(gl_InstanceIndex * _1071.instance_params.stride) + 2];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0, v);
        vtx_input.pos.y = dot(inst_m1, v);
        vtx_input.pos.z = dot(inst_m2, v);
        vec3 param_6 = vtx_input.norm;
        mat4 param_7 = transpose(mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_6, param_7));
        vec2 _1171 = unpackHalf2x16(_1164.instance_color[(gl_InstanceIndex * 2) + 0]);
        vec4 inst_c;
        inst_c.x = _1171.x;
        inst_c.y = _1171.y;
        vec2 _1181 = unpackHalf2x16(_1164.instance_color[(gl_InstanceIndex * 2) + 1]);
        inst_c.z = _1181.x;
        inst_c.w = _1181.y;
        vec4 _1187 = vtx_input.color;
        vec3 _1191 = _1187.xyz * inst_c.xyz;
        vtx_input.color.x = _1191.x;
        vtx_input.color.y = _1191.y;
        vtx_input.color.z = _1191.z;
    }
    instanceID = uint(gl_InstanceIndex);
    vtx_output.vLocalPos = vtx_input.pos;
    vec3 param_8 = vtx_input.pos;
    mat4 param_9 = _395.transform_params.mModel;
    vec3 vPosModel = vector_transform_by_mat43(param_8, param_9);
    vec3 param_10 = vtx_input.norm;
    mat4 param_11 = _395.transform_params.mModelNormal;
    vtx_output.vWorldNorm = vec3(vector_transform_by_mat33(param_10, param_11));
    vec3 param_12 = vPosModel;
    mat4 param_13 = _395.transform_params.mView;
    vec3 vPosModelView = vector_transform_by_mat43(param_12, param_13);
    vtx_output.vCoords = vPosModelView;
    vtx_output.vWorldPos = vPosModel;
    vtx_output.vWorldNorm = normalize(vtx_output.vWorldNorm);
    vtx_output.vNorm.x = dot(_395.transform_params.mModelViewInvTrans[0].xyz, vtx_input.norm);
    vtx_output.vNorm.y = dot(_395.transform_params.mModelViewInvTrans[1].xyz, vtx_input.norm);
    vtx_output.vNorm.z = dot(_395.transform_params.mModelViewInvTrans[2].xyz, vtx_input.norm);
    vtx_output.vNorm = vec3(normalize(vtx_output.vNorm));
    vtx_output.vNorm = vec3(vtx_input.norm);
    vtx_output.vColor = vec4(vtx_input.color);
    vtx_output.vUV0 = vec2(vtx_input.uv0);
    gl_Position = _395.transform_params.mProjection * vec4(vtx_output.vCoords, 1.0);
}

 