#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct MaskFromDepthParams
{
    vec2 resolution;
    vec2 inv_resolution;
    float base_depth;
    float depth_range;
    int depth_range_repeat;
    float depth_range_repeat_interval;
    float depth_min;
    float depth_max;
    int worldspace;
    int invert;
    int include_background;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _26;

layout(set = 0, binding = 2, std140) uniform MaskFromDepthParamsBuffer
{
    MaskFromDepthParams mask_from_depth_params;
} _161;

layout(set = 0, binding = 4) uniform sampler2D sAlbedo;
layout(set = 0, binding = 5) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 3, r8) uniform writeonly image2D imTarget;

float linearizeDepth(float d)
{
    return _26.dispatch_setup.near_far_plane.z / ((_26.dispatch_setup.near_far_plane.y + _26.dispatch_setup.near_far_plane.x) - (d * _26.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return _26.dispatch_setup.camera_position + (_26.dispatch_setup.mat_model * vec4(vDirection * depth, 0.0)).xyz;
}

void main()
{
    ivec2 storePos = ivec2(gl_GlobalInvocationID.xy);
    vec2 tex_coord = vec2(storePos) * _26.dispatch_setup.inv_resolution;
    vec3 view_direction;
    view_direction.x = ((-_26.dispatch_setup.camera_projection_params.x) * 0.5) + ((_26.dispatch_setup.camera_projection_params.x * float(storePos.x)) * _26.dispatch_setup.inv_resolution.x);
    view_direction.y = ((-_26.dispatch_setup.camera_projection_params.y) * 0.5) + ((_26.dispatch_setup.camera_projection_params.y * float(storePos.y)) * _26.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    vec4 albedo = texelFetch(sAlbedo, storePos, 0);
    float depth = texelFetch(sTextureDepth, storePos, 0).x;
    float param = depth;
    float linear_depth = linearizeDepth(param);
    vec3 param_1 = view_direction;
    float param_2 = linear_depth;
    vec3 view_coords = positionFromDepth(param_1, param_2);
    bool out_of_range = false;
    if (_161.mask_from_depth_params.worldspace != 0)
    {
        linear_depth = view_coords.z;
    }
    bool _174 = linear_depth <= _161.mask_from_depth_params.depth_min;
    bool _182;
    if (!_174)
    {
        _182 = linear_depth >= _161.mask_from_depth_params.depth_max;
    }
    else
    {
        _182 = _174;
    }
    if (_182)
    {
        out_of_range = true;
    }
    float output_val = 0.0;
    bool _188 = out_of_range == false;
    bool _198;
    if (_188)
    {
        _198 = (_161.mask_from_depth_params.include_background != 0) || (depth < 1.0);
    }
    else
    {
        _198 = _188;
    }
    if (_198)
    {
        float depth_diff = linear_depth - _161.mask_from_depth_params.base_depth;
        if (_161.mask_from_depth_params.depth_range_repeat != 0)
        {
            depth_diff = mod(depth_diff, _161.mask_from_depth_params.depth_range_repeat_interval);
        }
        if (depth_diff < _161.mask_from_depth_params.depth_range)
        {
            output_val = 1.0;
        }
    }
    if (_161.mask_from_depth_params.invert != 0)
    {
        output_val = 1.0 - output_val;
    }
    imageStore(imTarget, storePos, vec4(output_val, 0.0, 0.0, 0.0));
}

 