#version 450

struct BasicDeferredParams
{
    mat4 mModelview;
    mat4 mCameraModelview;
    mat4 mProjection;
    vec4 camera_near_far_plane;
    vec3 camera_position;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer VTXCoords
{
    float coords[];
} vtx_coords;

layout(set = 0, binding = 2, std430) buffer VTXUV0
{
    float uv0[];
} vtx_uv0;

layout(set = 0, binding = 3, std140) uniform BasicDeferredParamsBuffer
{
    layout(row_major) BasicDeferredParams basic_params;
} _75;

layout(location = 0) out vec2 vTexcoord0;

vec3 vtx_coords_load(uint idx)
{
    return vec3(vtx_coords.coords[(idx * 3u) + 0u], vtx_coords.coords[(idx * 3u) + 1u], vtx_coords.coords[(idx * 3u) + 2u]);
}

vec2 vtx_uv0_load(uint idx)
{
    return vec2(vtx_uv0.uv0[(idx * 2u) + 0u], vtx_uv0.uv0[(idx * 2u) + 1u]);
}

void main()
{
    uint param = uint(gl_VertexIndex);
    gl_Position = (_75.basic_params.mProjection * _75.basic_params.mModelview) * vec4(vtx_coords_load(param), 1.0);
    uint param_1 = uint(gl_VertexIndex);
    vTexcoord0 = vtx_uv0_load(param_1);
    vTexcoord0.y = 1.0 - vTexcoord0.y;
}

 