#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _29;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    vec4 base_color = vec4(1.0, 0.0, 0.5, 1.0);
    float v = vTexcoord0.x;
    float threshold = ((_29.params.param1 * 0.00999999977648258209228515625) - 0.25) * 1.5;
    float stripe_width = _29.params.param2 * 0.00999999977648258209228515625;
    float step_base = (v * 32.0) - (threshold * 32.0);
    float v2 = step(fract(step_base), 0.5);
    float v3 = step(fract(step_base), 0.949999988079071044921875);
    v = smoothstep(threshold - stripe_width, threshold + stripe_width, v);
    if (v == 1.0)
    {
        v2 = 1.0;
    }
    outColor.x = 0.0;
    outColor.y = 0.0;
    outColor.z = 0.0;
    v2 *= v;
    outColor.x = v2;
    v3 = 1.0 - (v3 * (1.0 - v2));
    if (v == 1.0)
    {
        v3 = 0.0;
    }
    if (v <= 0.5)
    {
        v3 = 0.0;
    }
    outColor.y = v3;
}

 