#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct RenderBackgroundParams
{
    vec4 fog_color;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _127;

layout(set = 0, binding = 2, std140) uniform RenderBackgroundParamsBuffer
{
    RenderBackgroundParams render_background_params;
} _316;

layout(set = 0, binding = 3, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 6) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 4, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 7) uniform samplerCube sEnviromentMap;
layout(set = 0, binding = 5, rgba16f) uniform writeonly image2D imTarget;

int decode_material(uint data)
{
    return int(data >> 31u);
}

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

float linearizeDepth(float d)
{
    return _127.dispatch_setup.near_far_plane.z / ((_127.dispatch_setup.near_far_plane.y + _127.dispatch_setup.near_far_plane.x) - (d * _127.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return (_127.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    ivec2 pos = ivec2(pixel_pos);
    uint encoded_normal_material = imageLoad(imNormalMaterial, pos).x;
    uint param = encoded_normal_material;
    int materialId = decode_material(param);
    if ((materialId & 1) != 1)
    {
    }
    else
    {
        vec3 view_direction;
        view_direction.x = (-_127.dispatch_setup.camera_projection_params.z) + ((_127.dispatch_setup.camera_projection_params.x * float(pos.x)) * _127.dispatch_setup.inv_resolution.x);
        view_direction.y = (-_127.dispatch_setup.camera_projection_params.w) + ((_127.dispatch_setup.camera_projection_params.y * float(pos.y)) * _127.dispatch_setup.inv_resolution.y);
        view_direction.z = 1.0;
        view_direction.y = -view_direction.y;
        uint encoded_normal_material_1 = imageLoad(imNormalMaterial, pos).x;
        uint param_1 = encoded_normal_material_1;
        vec3 vNorm = decode_normal(param_1);
        uint param_2 = encoded_normal_material_1;
        int materialId_1 = decode_material(param_2);
        float param_3 = texelFetch(sTextureDepth, pos, 0).x;
        float depth = linearizeDepth(param_3);
        vec3 param_4 = view_direction;
        float param_5 = depth;
        vec3 world = positionFromDepth(param_4, param_5);
        uvec2 param_6 = imageLoad(imMetalnessRoughnessMaterialTags, pos).xy;
        float param_7;
        float param_8;
        uint param_9;
        decode_metalness_roughness_material(param_6, param_7, param_8, param_9);
        float metalness = param_7;
        float roughness = param_8;
        uint material = param_9;
        vec3 dir = world - _127.dispatch_setup.camera_position;
        float max_t = length(dir);
        dir /= vec3(max_t);
        vec3 ro = _127.dispatch_setup.camera_position;
        vec3 rd = dir;
        float fog_blend = 1.0 - pow(clamp(rd.y, 0.0, 1.0), 0.89999997615814208984375);
        vec3 fog_color = _316.render_background_params.fog_color.xyz;
        vec3 env_map = textureLod(sEnviromentMap, normalize(rd), 0.0).xyz;
        imageStore(imTarget, pos, vec4(mix(env_map, fog_color, vec3(fog_blend)), 1.0));
    }
}

 