#version 450

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct _388
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _426;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _673;

layout(set = 1, binding = 4) uniform sampler2D material_textures[64];

layout(location = 1) in _388 vtx_input;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;
layout(location = 3) out vec4 outEmissive;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;

vec3 getMaterialNormal(MaterialPropertiesGPU material, vec3 normal, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return normal;
}

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    if (material.albedo_sampler != (-1))
    {
        vec4 v = texture(material_textures[material.albedo_sampler], vtx_input.vUV0);
        if (v.w > 0.5)
        {
            return true;
        }
    }
    return false;
}

vec3 mapping_triplanar_normal(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec3 axis_sign = sign(n);
    vec3 xaxis = (texture(smpl, coords.zy * scale.zy).xyz * 2.0) - vec3(1.0);
    vec3 yaxis = (texture(smpl, coords.xz * scale.xz).xyz * 2.0) - vec3(1.0);
    vec3 zaxis = (texture(smpl, coords.xy * scale.xy).xyz * 2.0) - vec3(1.0);
    xaxis.z *= axis_sign.x;
    yaxis.z *= axis_sign.y;
    zaxis.z *= axis_sign.z;
    vec3 tex = normalize(((xaxis.zyx * blending.x) + (yaxis.xzy * blending.y)) + (zaxis * blending.z));
    return tex;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

uint packSnorm2x15(vec2 v)
{
    uvec2 d = uvec2(round(vec2(16383.5) + (v * 16383.5)));
    return d.x | (d.y << 15u);
}

uint encode_normal_31bit(vec3 n)
{
    vec2 v = n.xy;
    uint s = uint((n.z > 0.0) ? 1073741824 : 0);
    vec2 param = v;
    return s | packSnorm2x15(param);
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint normal_material = encode_normal_31bit(param);
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

vec4 getMaterialAlbedo(MaterialPropertiesGPU material, vec4 albedo, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return vec4(1.0);
}

vec4 mapping_triplanar(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec4 xaxis = texture(smpl, coords.yz * scale.yz);
    vec4 yaxis = texture(smpl, coords.xz * scale.xz);
    vec4 zaxis = texture(smpl, coords.xy * scale.xy);
    vec4 tex = ((xaxis * blending.x) + (yaxis * blending.y)) + (zaxis * blending.z);
    return tex;
}

vec3 getMaterialEmissive(MaterialPropertiesGPU material, vec3 emissive, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return emissive;
}

float getMaterialRoughness(MaterialPropertiesGPU material, float roughness, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return roughness;
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

uvec2 encode_component_tags(uint component_tags)
{
    return uvec2(component_tags & 65535u, component_tags >> uint(16));
}

void main()
{
    MaterialPropertiesGPU _434;
    _434.diffuse = materials.material_properties[_426.materialIndex].diffuse;
    _434.transparency = materials.material_properties[_426.materialIndex].transparency;
    _434.emissive = materials.material_properties[_426.materialIndex].emissive;
    _434.roughness = materials.material_properties[_426.materialIndex].roughness;
    _434.triplanar_factor = materials.material_properties[_426.materialIndex].triplanar_factor;
    _434.refraction = materials.material_properties[_426.materialIndex].refraction;
    _434.normal_factor = materials.material_properties[_426.materialIndex].normal_factor;
    _434.emissive_factor = materials.material_properties[_426.materialIndex].emissive_factor;
    _434.temporal_accumulation_factor = materials.material_properties[_426.materialIndex].temporal_accumulation_factor;
    _434.shadowmap_bias = materials.material_properties[_426.materialIndex].shadowmap_bias;
    _434.metalness = materials.material_properties[_426.materialIndex].metalness;
    _434.albedo_sampler = materials.material_properties[_426.materialIndex].albedo_sampler;
    _434.emissive_sampler = materials.material_properties[_426.materialIndex].emissive_sampler;
    _434.normal_sampler = materials.material_properties[_426.materialIndex].normal_sampler;
    _434.metalic_roughness_sampler = materials.material_properties[_426.materialIndex].metalic_roughness_sampler;
    _434.flags = materials.material_properties[_426.materialIndex].flags;
    _434._pad0 = materials.material_properties[_426.materialIndex]._pad0;
    _434._pad1 = materials.material_properties[_426.materialIndex]._pad1;
    MaterialPropertiesGPU material = _434;
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    vec3 norm = vtx_input.vNorm;
    if ((material.flags & 128u) != 0u)
    {
        vec3 dFdxPos = dFdx(vtx_input.vWorldPos);
        vec3 dFdyPos = dFdy(vtx_input.vWorldPos);
        worldNorm = cross(dFdyPos, dFdxPos);
        dFdxPos = dFdx(vtx_input.vLocalPos);
        dFdyPos = dFdy(vtx_input.vLocalPos);
        norm = normalize(cross(dFdyPos, dFdxPos));
        worldNorm = -worldNorm;
        norm = -norm;
    }
    vec3 normal = normalize(worldNorm);
    MaterialPropertiesGPU param = material;
    vec3 param_1 = normal;
    vec3 param_2 = vtx_input.vWorldPos;
    vec3 param_3 = vtx_input.vLocalPos;
    vec3 param_4 = vtx_input.vNorm;
    vec3 param_5 = vtx_input.vWorldNorm;
    normal = getMaterialNormal(param, param_1, param_2, param_3, param_4, param_5);
    MaterialPropertiesGPU param_6 = material;
    vec3 param_7 = vtx_input.vWorldPos;
    vec3 param_8 = vtx_input.vLocalPos;
    vec3 param_9 = vtx_input.vNorm;
    vec3 param_10 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param_6, param_7, param_8, param_9, param_10);
    if (to_discard)
    {
        discard;
    }
    bool _529 = material.normal_sampler >= 0;
    bool _535;
    if (_529)
    {
        _535 = material.normal_sampler < 16;
    }
    else
    {
        _535 = _529;
    }
    if (_535)
    {
        if ((material.flags & 1024u) == 0u)
        {
            vec3 pos_dx = dFdx(vtx_input.vWorldPos);
            vec3 pos_dy = dFdy(vtx_input.vWorldPos);
            vec3 tex_dx = dFdx(vec3(vtx_input.vUV0, 0.0));
            vec3 tex_dy = dFdy(vec3(vtx_input.vUV0, 0.0));
            float denom = (tex_dx.x * tex_dy.y) - (tex_dy.x * tex_dx.y);
            if (abs(denom) >= 1.0000000133514319600180897396058e-10)
            {
                vec3 t = ((pos_dx * tex_dy.y) - (pos_dy * tex_dx.y)) / vec3(denom);
                vec3 ng = normal;
                t = normalize(t - (ng * dot(ng, t)));
                vec3 b = normalize(cross(ng, t));
                mat3 tbn = mat3(vec3(t), vec3(b), vec3(ng));
                vec3 n = (texture(material_textures[material.normal_sampler], vtx_input.vUV0).xyz * 2.0) - vec3(1.0);
                n = mix(vec3(0.0, 0.0, 1.0), n, vec3(material.normal_factor));
                n = normalize(n * transpose(tbn));
                normal = n;
            }
        }
        else
        {
            vec3 param_11 = vtx_input.vLocalPos;
            vec3 param_12 = norm;
            vec3 param_13 = material.triplanar_factor;
            vec3 n_1 = mapping_triplanar_normal(material_textures[material.normal_sampler], param_11, param_12, param_13);
            vec3 param_14 = n_1;
            mat4 param_15 = _673.transform_params.mModelNormal;
            n_1 = vector_transform_by_mat43(param_14, param_15);
            n_1 = normalize(n_1);
            n_1 = mix(normal, n_1, vec3(material.normal_factor));
            normal = n_1;
        }
    }
    vec2 uv0 = vtx_input.vUV0;
    vec3 param_16 = normal;
    int param_17 = _426.materialId;
    outNormalMaterial = encode_normal_material(param_16, param_17);
    outAlbedo = vec4(1.0);
    MaterialPropertiesGPU param_18 = material;
    vec4 param_19 = outAlbedo;
    vec3 param_20 = vtx_input.vWorldPos;
    vec3 param_21 = vtx_input.vLocalPos;
    vec3 param_22 = vtx_input.vNorm;
    vec3 param_23 = vtx_input.vWorldNorm;
    outAlbedo = getMaterialAlbedo(param_18, param_19, param_20, param_21, param_22, param_23);
    bool _722 = material.albedo_sampler >= 0;
    bool _728;
    if (_722)
    {
        _728 = material.albedo_sampler < 16;
    }
    else
    {
        _728 = _722;
    }
    if (_728)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param_24 = vtx_input.vLocalPos;
            vec3 param_25 = norm;
            vec3 param_26 = material.triplanar_factor;
            outAlbedo *= mapping_triplanar(material_textures[material.albedo_sampler], param_24, param_25, param_26);
        }
        else
        {
            outAlbedo *= texture(material_textures[material.albedo_sampler], uv0);
        }
    }
    vec4 _765 = outAlbedo;
    vec3 _767 = _765.xyz * vtx_input.vColor.xyz;
    outAlbedo.x = _767.x;
    outAlbedo.y = _767.y;
    outAlbedo.z = _767.z;
    outEmissive = vec4(0.0);
    MaterialPropertiesGPU param_27 = material;
    vec3 param_28 = outEmissive.xyz;
    vec3 param_29 = vtx_input.vWorldPos;
    vec3 param_30 = vtx_input.vLocalPos;
    vec3 param_31 = vtx_input.vNorm;
    vec3 param_32 = vtx_input.vWorldNorm;
    vec3 _794 = getMaterialEmissive(param_27, param_28, param_29, param_30, param_31, param_32);
    outEmissive.x = _794.x;
    outEmissive.y = _794.y;
    outEmissive.z = _794.z;
    if (false)
    {
        bool _806 = material.emissive_sampler >= 0;
        bool _812;
        if (_806)
        {
            _812 = material.emissive_sampler < 16;
        }
        else
        {
            _812 = _806;
        }
        if (_812)
        {
            if ((material.flags & 1024u) != 0u)
            {
                vec3 param_33 = vtx_input.vLocalPos;
                vec3 param_34 = norm;
                vec3 param_35 = material.triplanar_factor;
                vec4 _834 = outEmissive;
                vec3 _836 = _834.xyz * mapping_triplanar(material_textures[material.emissive_sampler], param_33, param_34, param_35).xyz;
                outEmissive.x = _836.x;
                outEmissive.y = _836.y;
                outEmissive.z = _836.z;
            }
            else
            {
                vec4 _851 = outEmissive;
                vec3 _853 = _851.xyz * texture(material_textures[material.emissive_sampler], uv0).xyz;
                outEmissive.x = _853.x;
                outEmissive.y = _853.y;
                outEmissive.z = _853.z;
            }
        }
    }
    float roughness = material.roughness;
    MaterialPropertiesGPU param_36 = material;
    float param_37 = roughness;
    vec3 param_38 = vtx_input.vWorldPos;
    vec3 param_39 = vtx_input.vLocalPos;
    vec3 param_40 = vtx_input.vNorm;
    vec3 param_41 = vtx_input.vWorldNorm;
    roughness = getMaterialRoughness(param_36, param_37, param_38, param_39, param_40, param_41);
    bool _883 = material.metalic_roughness_sampler >= 0;
    bool _889;
    if (_883)
    {
        _889 = material.metalic_roughness_sampler < 16;
    }
    else
    {
        _889 = _883;
    }
    if (_889)
    {
        roughness *= clamp(texture(material_textures[material.metalic_roughness_sampler], uv0).y, 0.0, 1.0);
    }
    float param_42 = material.metalness;
    float param_43 = roughness;
    uint param_44 = uint(_426.materialIndex);
    uvec2 _915 = encode_metalness_roughness_material(param_42, param_43, param_44);
    outMetalnessRoughnessMeterialTags.x = _915.x;
    outMetalnessRoughnessMeterialTags.y = _915.y;
    uint param_45 = uint(_426.componentTags);
    uvec2 _924 = encode_component_tags(param_45);
    outMetalnessRoughnessMeterialTags.z = _924.x;
    outMetalnessRoughnessMeterialTags.w = _924.y;
}

 