#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct CompositeParams
{
    vec4 global_ambient_color;
    vec4 global_fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float ssr_scaling_factor;
    float ssr_strength;
    float sso_strength;
    float occlusion_strength;
    float global_illumination_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float taa_blend;
    float taa_gamma;
    int composite_output_mode;
    float raytrace_scaling_factor;
    int transparency_blend_mode;
    float _pad1;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _63;

layout(set = 0, binding = 2, std140) uniform CompositeParamsBuffer
{
    CompositeParams composite_setup;
} _213;

layout(set = 0, binding = 3, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 0, binding = 5) uniform usampler2D sNormalMaterial;
layout(set = 0, binding = 6) uniform sampler2D sAlbedo;
layout(set = 0, binding = 7) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 8) uniform sampler2D sShadow;
layout(set = 0, binding = 9) uniform sampler2D sVoxelLighting;
layout(set = 0, binding = 10) uniform sampler2D sScreenSpaceOcclusion;
layout(set = 0, binding = 11) uniform sampler2D sParticles;
layout(set = 0, binding = 12) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 13) uniform sampler2D sVolumetricFog;
layout(set = 0, binding = 4, rgba16f) uniform writeonly image2D imTarget;

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _63.dispatch_setup.near_far_plane.z / ((_63.dispatch_setup.near_far_plane.y + _63.dispatch_setup.near_far_plane.x) - (d * _63.dispatch_setup.near_far_plane.w));
}

vec3 positionFromDepthCurrent(vec3 vDirection, float depth)
{
    return (_63.dispatch_setup.mat_model * vec4(vDirection * depth, 1.0)).xyz;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uvec2 ct, out uint component_tags)
{
    component_tags = ct.x | (ct.y << uint(16));
}

vec4 calculate_lighting_fill(vec3 pos, vec3 normal, vec3 light_pos, vec3 cam_pos, float NdotL)
{
    float d = NdotL;
    if (d < 0.0)
    {
        d = 0.0;
    }
    vec3 specular = vec3(0.0);
    if (d > 0.0)
    {
        specular = _213.composite_setup.global_fill_color.xxx * pow(max(0.0, dot(reflect(-normalize(pos - light_pos), normalize(normal)), -normalize(cam_pos - pos))), 14.0);
    }
    return vec4((vec3(d) * _213.composite_setup.global_fill_color.xyz) + specular, 1.0);
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    uvec2 pixel_pos_inv_y = pixel_pos;
    pixel_pos_inv_y.y = uint(_63.dispatch_setup.resolution.y) - pixel_pos_inv_y.y;
    vec3 view_direction;
    view_direction.x = (-_63.dispatch_setup.camera_projection_params.z) + ((_63.dispatch_setup.camera_projection_params.x * float(pixel_pos.x)) * _63.dispatch_setup.inv_resolution.x);
    view_direction.y = (-_63.dispatch_setup.camera_projection_params.w) + ((_63.dispatch_setup.camera_projection_params.y * float(pixel_pos.y)) * _63.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    float dither = 0.0;
    uint encoded_normal_material = texelFetch(sNormalMaterial, ivec2(pixel_pos), 0).x;
    uint param = encoded_normal_material;
    vec3 normal = decode_normal(param);
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    MaterialPropertiesGPU material;
    material.flags = 0u;
    bool is_background = false;
    float depth = 0.0;
    vec4 albedo;
    vec4 color;
    if ((materialId & 1) == 1)
    {
        is_background = true;
        albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
        color = albedo;
    }
    vec3 local_normal = vec3(0.0, 0.0, -1.0);
    vec4 shadow = vec4(1.0, 1.0, 1.0, 0.0);
    vec4 voxel_light = vec4(0.0);
    albedo = texelFetch(sAlbedo, ivec2(pixel_pos), 0);
    if (is_background == false)
    {
        local_normal.x = dot(normal, _63.dispatch_setup.mat_model[0].xyz);
        local_normal.y = dot(normal, _63.dispatch_setup.mat_model[1].xyz);
        local_normal.z = dot(normal, _63.dispatch_setup.mat_model[2].xyz);
        depth = texelFetch(sTextureDepth, ivec2(pixel_pos), 0).x;
        shadow = texelFetch(sShadow, ivec2(pixel_pos), 0);
        voxel_light = texelFetch(sVoxelLighting, ivec2(pixel_pos), 0);
        vec4 color_1 = vec4(0.0);
        vec3 _398 = abs(local_normal);
        color_1.x = _398.x;
        color_1.y = _398.y;
        color_1.z = _398.z;
    }
    float param_2 = depth;
    float linear_depth = linearizeDepth(param_2);
    float hbao = max(texelFetch(sScreenSpaceOcclusion, ivec2(pixel_pos), 0).x, 0.0);
    if (_213.composite_setup.sso_strength > 0.0)
    {
        hbao = pow(hbao, _213.composite_setup.sso_strength);
    }
    vec4 ssr = vec4(0.0);
    vec4 particles = texelFetch(sParticles, ivec2(pixel_pos), 0);
    float ssr_factor = 0.0;
    vec3 param_3 = view_direction;
    float param_4 = linear_depth;
    vec3 world = positionFromDepthCurrent(param_3, param_4);
    uvec2 param_5 = texelFetch(sMetalnessRoughnessMaterialTags, ivec2(pixel_pos), 0).xy;
    float param_6;
    float param_7;
    uint param_8;
    decode_metalness_roughness_material(param_5, param_6, param_7, param_8);
    float metalness = param_6;
    float roughness = param_7;
    uint materialIndex = param_8;
    uvec2 param_9 = texelFetch(sMetalnessRoughnessMaterialTags, ivec2(pixel_pos), 0).zw;
    uint param_10;
    decode_component_tags(param_9, param_10);
    uint component_tags = param_10;
    if (is_background == false)
    {
        MaterialPropertiesGPU _485;
        _485.diffuse = materials.material_properties[materialIndex].diffuse;
        _485.transparency = materials.material_properties[materialIndex].transparency;
        _485.emissive = materials.material_properties[materialIndex].emissive;
        _485.roughness = materials.material_properties[materialIndex].roughness;
        _485.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
        _485.refraction = materials.material_properties[materialIndex].refraction;
        _485.normal_factor = materials.material_properties[materialIndex].normal_factor;
        _485.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
        _485.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
        _485.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
        _485.metalness = materials.material_properties[materialIndex].metalness;
        _485.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
        _485.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
        _485.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
        _485.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
        _485.flags = materials.material_properties[materialIndex].flags;
        _485._pad0 = materials.material_properties[materialIndex]._pad0;
        _485._pad1 = materials.material_properties[materialIndex]._pad1;
        material = _485;
    }
    vec4 _495 = shadow;
    vec3 _497 = _495.xyz + ((albedo.xyz * voxel_light.xyz) * _213.composite_setup.global_illumination_strength);
    shadow.x = _497.x;
    shadow.y = _497.y;
    shadow.z = _497.z;
    vec4 _510 = shadow;
    vec3 _512 = _510.xyz * (1.0 - (voxel_light.w * _213.composite_setup.occlusion_strength));
    shadow.x = _512.x;
    shadow.y = _512.y;
    shadow.z = _512.z;
    vec3 param_11 = world;
    vec3 param_12 = local_normal;
    vec3 param_13 = vec3(0.0);
    vec3 param_14 = vec3(0.0);
    float param_15 = dot(local_normal, normalize(-world));
    vec4 fill_color = calculate_lighting_fill(param_11, param_12, param_13, param_14, param_15);
    vec4 _535 = shadow;
    vec3 _537 = _535.xyz + fill_color.xyz;
    shadow.x = _537.x;
    shadow.y = _537.y;
    shadow.z = _537.z;
    vec4 _544 = shadow;
    vec3 _547 = _544.xyz * hbao;
    shadow.x = _547.x;
    shadow.y = _547.y;
    shadow.z = _547.z;
    color.w = 1.0;
    if (is_background == false)
    {
        vec3 _570 = (vec3(max(0.0, 1.0 - shadow.w)) * shadow.xyz) + _213.composite_setup.global_ambient_color.xyz;
        color.x = _570.x;
        color.y = _570.y;
        color.z = _570.z;
    }
    shadow.w = pow((shadow.w * linear_depth) / 10.0, 2.0);
    vec4 _590 = color;
    vec3 _592 = _590.xyz + (ssr.xyz * 4.0);
    color.x = _592.x;
    color.y = _592.y;
    color.z = _592.z;
    vec4 _601 = color;
    vec3 _604 = _601.xyz + vec3(shadow.w);
    color.x = _604.x;
    color.y = _604.y;
    color.z = _604.z;
    if (_213.composite_setup.composite_output_mode == 0)
    {
        vec4 _625 = color;
        vec3 _627 = _625.xyz * (1.0 - ((voxel_light.w * _213.composite_setup.occlusion_strength) * 0.550000011920928955078125));
        color.x = _627.x;
        color.y = _627.y;
        color.z = _627.z;
        float fog_density = linear_depth;
        if (_213.composite_setup.fog_range > 0.0)
        {
            fog_density /= _213.composite_setup.fog_range;
        }
        else
        {
            fog_density = 0.0;
        }
        float fog_height_density = (1.0 - clamp(abs(world.y) / _213.composite_setup.fog_height, 0.0, 1.0)) * _213.composite_setup.fog_height_density;
        fog_density = exp(fog_density + fog_height_density) - 1.0;
        float fog_density_margin = 0.00999999977648258209228515625;
        fog_density = clamp(fog_density, fog_density_margin, 1.0 - fog_density_margin);
        vec3 fog_color = _213.composite_setup.fog_color.xyz;
        vec4 _677 = color;
        vec3 _682 = mix(_677.xyz, fog_color, vec3(fog_density));
        color.x = _682.x;
        color.y = _682.y;
        color.z = _682.z;
        vec4 volumetric_fog_color = texelFetch(sVolumetricFog, ivec2(pixel_pos), 0);
        if (_213.composite_setup.volumetric_fog_intensity > 0.0)
        {
            vec4 _702 = volumetric_fog_color;
            vec3 _707 = pow(_702.xyz, vec3(_213.composite_setup.volumetric_fog_intensity));
            volumetric_fog_color.x = _707.x;
            volumetric_fog_color.y = _707.y;
            volumetric_fog_color.z = _707.z;
        }
        float volumetric_fog_blend = volumetric_fog_color.w;
        if (_213.composite_setup.volumetric_fog_strength > 0.0)
        {
            volumetric_fog_blend = exp((-volumetric_fog_color.w) / _213.composite_setup.volumetric_fog_strength);
        }
        else
        {
            volumetric_fog_blend = 0.0;
        }
        vec4 _731 = color;
        vec3 _737 = mix(_731.xyz, volumetric_fog_color.xyz, vec3(volumetric_fog_blend));
        color.x = _737.x;
        color.y = _737.y;
        color.z = _737.z;
        if (uint(_213.composite_setup.transparency_blend_mode) == 0u)
        {
            vec4 _756 = color;
            vec3 _758 = _756.xyz + (particles.xyz * (1.0 - volumetric_fog_blend));
            color.x = _758.x;
            color.y = _758.y;
            color.z = _758.z;
        }
        if (uint(_213.composite_setup.transparency_blend_mode) == 1u)
        {
            vec4 _771 = color;
            vec3 _779 = mix(_771.xyz, particles.xyz, vec3(1.0 - particles.w));
            color.x = _779.x;
            color.y = _779.y;
            color.z = _779.z;
        }
    }
    imageStore(imTarget, ivec2(pixel_pos), color);
}

 