#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
    float time_step;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleEmitterPrimitive_Params
{
    mat4 transform;
    vec4 particle_color;
    vec3 primitive_size;
    int perimeter_only;
    int primitive_type;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VM1Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _183;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    vec4 prt_positions[];
} _209;

layout(set = 0, binding = 5, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _751;

layout(set = 0, binding = 3, std430) buffer VM0
{
    ParticleModifierCurl_Params VM0_params;
} _918;

layout(set = 0, binding = 6, std140) uniform VM1
{
    VM1Params VM1_params;
} _934;

layout(set = 0, binding = 4, std430) buffer VM2
{
    layout(row_major) ParticleEmitterPrimitive_Params VM2_params;
} _958;

layout(set = 0, binding = 7, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _982;

vec3 prt_get_position(uint id)
{
    return _209.prt_positions[id].xyz;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _189;
    _189.life_time = _183.prt_states[id].life_time;
    _189.life_span = _183.prt_states[id].life_span;
    _189.generation_id = _183.prt_states[id].generation_id;
    _189.color = _183.prt_states[id].color;
    ParticleState _188 = _189;
    return _188;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_751.globals.time, _751.globals.time * 0.3014999926090240478515625, (-_751.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _775 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += ((_775 * modifier_params.noise_strength) * modifier_params.time_step);
}

float particle_emitter_primitive_rand(float n)
{
    return fract(sin(n) * 43758.546875);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    state.generation_id += 1.0;
}

vec3 vector_transform_by_mat43(vec3 v, mat4 m)
{
    return (m * vec4(v, 1.0)).xyz;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _229 = color_convert_rgb_float3_uint(param);
    uint v = _229;
    state.color = v;
}

void particle_emitter_primitive_emit(ParticleEmitterPrimitive_Params emitter_params, inout Particle p, uint id)
{
    float fid = float(id);
    float param = fid * 5.131999969482421875;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_primitive_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    float param_3 = fid * 0.0130000002682209014892578125;
    float param_4 = (fid * 0.112999998033046722412109375) + 132.1410064697265625;
    float param_5 = (fid * 0.3129999935626983642578125) - 43.120998382568359375;
    vec3 pos = (vec3(particle_emitter_primitive_rand(param_3), particle_emitter_primitive_rand(param_4), particle_emitter_primitive_rand(param_5)) * 2.0) - vec3(1.0);
    if (emitter_params.primitive_type == 0)
    {
        float l = length(pos);
        if (l > 1.0)
        {
            pos /= vec3(l);
        }
        pos *= emitter_params.primitive_size;
    }
    else
    {
        if (emitter_params.primitive_type == 1)
        {
            pos *= emitter_params.primitive_size;
        }
    }
    vec3 param_6 = pos;
    mat4 param_7 = emitter_params.transform;
    pos = vector_transform_by_mat43(param_6, param_7);
    p.pos = pos;
    ParticleState param_8 = p.state;
    vec3 param_9 = emitter_params.particle_color.xyz;
    prt_set_color(param_8, param_9);
    p.state = param_8;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _196;
    _196.life_time = state.life_time;
    _196.life_span = state.life_span;
    _196.generation_id = state.generation_id;
    _196.color = state.color;
    _183.prt_states[id] = _196;
}

void prt_set_position(uint id, vec3 p)
{
    _209.prt_positions[id].x = p.x;
    _209.prt_positions[id].y = p.y;
    _209.prt_positions[id].z = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    ParticleState param_2 = p.state;
    if (prt_is_alive(param_2))
    {
        ParticleModifierCurl_Params _923;
        _923.position = _918.VM0_params.position;
        _923.falloff_mode = _918.VM0_params.falloff_mode;
        _923.radius = _918.VM0_params.radius;
        _923.falloff_inverse = _918.VM0_params.falloff_inverse;
        _923.noise_strength = _918.VM0_params.noise_strength;
        _923.noise_speed = _918.VM0_params.noise_speed;
        _923.noise_scale = _918.VM0_params.noise_scale;
        _923.time_step = _918.VM0_params.time_step;
        ParticleModifierCurl_Params param_3 = _923;
        Particle param_4 = p;
        uint param_5 = id;
        particle_modifier_curl(param_3, param_4, param_5);
        p = param_4;
    }
    vec3 modifier_position = _934.VM1_params.position;
    p.pos += (_934.VM1_params.velocity * _934.VM1_params.time_step);
    ParticleState param_6 = p.state;
    if (!prt_is_alive(param_6))
    {
        int _963 = atomicAdd(_958.VM2_params.pending, -1);
        int pending = _963;
        if (pending > 0)
        {
            ParticleEmitterPrimitive_Params _972;
            _972.transform = _958.VM2_params.transform;
            _972.particle_color = _958.VM2_params.particle_color;
            _972.primitive_size = _958.VM2_params.primitive_size;
            _972.perimeter_only = _958.VM2_params.perimeter_only;
            _972.primitive_type = _958.VM2_params.primitive_type;
            _972.particle_lifetime = _958.VM2_params.particle_lifetime;
            _972.particle_lifetime_randomness = _958.VM2_params.particle_lifetime_randomness;
            _972.rate = _958.VM2_params.rate;
            _972.seed = _958.VM2_params.seed;
            _972.pending = _958.VM2_params.pending;
            ParticleEmitterPrimitive_Params param_7 = _972;
            Particle param_8 = p;
            uint param_9 = id;
            particle_emitter_primitive_emit(param_7, param_8, param_9);
            p = param_8;
        }
    }
    ParticleState param_10 = p.state;
    float param_11 = _982.lifecycle_params.time_step;
    float param_12 = _982.lifecycle_params.max_lifetime;
    prt_advance_life(param_10, param_11, param_12);
    p.state = param_10;
    uint param_13 = id;
    ParticleState param_14 = p.state;
    prt_set_state(param_13, param_14);
    uint param_15 = id;
    vec3 param_16 = p.pos;
    prt_set_position(param_15, param_16);
}

 