#version 450
layout(depth_greater) out float gl_FragDepth;

struct RaymarchParams
{
    vec3 function_scale;
    int show_bounding_box;
    vec3 function_origin;
    int clamp_to_volume;
    float param1;
    float param2;
    float param3;
    float param4;
    int use_instance_origin;
    int txt1_flip_y;
    int txt2_flip_y;
    int gradient_idx;
    vec4 near_far_plane;
    int trace_inside;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    vec3 vCameraPosition;
};

struct _817
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 2, std140) uniform RaymarchParamsBuffer
{
    RaymarchParams raymarch_params;
} _156;

layout(set = 1, binding = 3, std140) uniform MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[512];
} materials;

layout(set = 1, binding = 4, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _576;

layout(set = 1, binding = 5, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _600;

layout(set = 1, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _610;

layout(set = 1, binding = 6, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _716;

layout(location = 0) flat in uint instanceID;
layout(location = 1) in _817 vtx_input;

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

float sdBox(vec3 p, vec3 b)
{
    vec3 q = abs(p) - b;
    return length(max(q, vec3(0.0))) + min(max(q.x, max(q.y, q.z)), 0.0);
}

float raymarchBBox(vec3 ro, vec3 rd, vec3 function_scale)
{
    float h = 0.00200000009499490261077880859375;
    float t = 0.0;
    float res = -1.0;
    for (int i = 0; i < 32; i++)
    {
        if ((h < 0.001000000047497451305389404296875) || (t > 2000.0))
        {
            break;
        }
        vec3 param = ro + (rd * t);
        vec3 param_1 = vec3(1000.0);
        vec3 param_2 = ro + (rd * t);
        vec3 param_3 = (function_scale * 0.5) + vec3(0.00999999977648258209228515625);
        h = max(sdBox(param, param_1), -sdBox(param_2, param_3));
        t += h;
    }
    if (t < 2000.0)
    {
        res = t;
    }
    return res;
}

vec2 DE(vec3 pos)
{
    float Power = 3.0 + (4.0 * (clamp(_156.raymarch_params.param1, -1.2999999523162841796875, 20.0) + 1.0));
    vec3 z = pos;
    float dr = 1.0;
    float r = 0.0;
    for (int i = 0; i < 32; i++)
    {
        r = length(z);
        if (r > 1.5)
        {
            break;
        }
        float theta = acos(z.z / r);
        float phi = atan(z.y, z.x);
        dr = ((pow(r, Power - 1.0) * Power) * dr) + 1.0;
        float zr = pow(r, Power);
        theta = (theta * Power) + _156.raymarch_params.param2;
        phi = (phi * Power) + _156.raymarch_params.param3;
        z = vec3(sin(theta) * cos(phi), sin(phi) * sin(theta), cos(theta)) * zr;
        z += pos;
    }
    return vec2(((0.5 * log(r)) * r) / dr, 50.0 * pow(dr, 0.00200000009499490261077880859375));
}

vec2 map(vec3 p, vec3 dummy)
{
    vec3 param = p;
    vec2 d = DE(param);
    return d;
}

float calcIntersection(vec3 ro, vec3 rd, float max_t, inout vec4 color)
{
    color = vec4(1.0);
    float maxd = max_t;
    float h = 0.00039999998989515006542205810546875;
    float t = 0.0;
    float res = -1.0;
    vec3 orbit_trap;
    for (int i = 0; i < 32; i++)
    {
        if ((h < 0.00019999999494757503271102905273438) || (t > maxd))
        {
            break;
        }
        vec3 param = ro + (rd * t);
        vec3 param_1 = orbit_trap;
        vec2 o = map(param, param_1);
        h = o.x;
        vec3 _309 = vec3(o.y);
        color.x = _309.x;
        color.y = _309.y;
        color.z = _309.z;
        t += h;
    }
    if (t < maxd)
    {
        res = t;
    }
    if (t > max_t)
    {
        return -1.0;
    }
    vec4 _333 = color;
    vec3 _335 = fract(_333.xyz);
    color.x = _335.x;
    color.y = _335.y;
    color.z = _335.z;
    return res;
}

void main()
{
    MaterialPropertiesGPU _583;
    _583.diffuse = materials.material_properties[_576.materialIndex].diffuse;
    _583.transparency = materials.material_properties[_576.materialIndex].transparency;
    _583.emissive = materials.material_properties[_576.materialIndex].emissive;
    _583.roughness = materials.material_properties[_576.materialIndex].roughness;
    _583.triplanar_factor = materials.material_properties[_576.materialIndex].triplanar_factor;
    _583.refraction = materials.material_properties[_576.materialIndex].refraction;
    _583.normal_factor = materials.material_properties[_576.materialIndex].normal_factor;
    _583.emissive_factor = materials.material_properties[_576.materialIndex].emissive_factor;
    _583.temporal_accumulation_factor = materials.material_properties[_576.materialIndex].temporal_accumulation_factor;
    _583.shadowmap_bias = materials.material_properties[_576.materialIndex].shadowmap_bias;
    _583.metalness = materials.material_properties[_576.materialIndex].metalness;
    _583.albedo_sampler = materials.material_properties[_576.materialIndex].albedo_sampler;
    _583.emissive_sampler = materials.material_properties[_576.materialIndex].emissive_sampler;
    _583.normal_sampler = materials.material_properties[_576.materialIndex].normal_sampler;
    _583.metalic_roughness_sampler = materials.material_properties[_576.materialIndex].metalic_roughness_sampler;
    _583.flags = materials.material_properties[_576.materialIndex].flags;
    _583._pad0 = materials.material_properties[_576.materialIndex]._pad0;
    _583._pad1 = materials.material_properties[_576.materialIndex]._pad1;
    MaterialPropertiesGPU material = _583;
    vec4 outAlbedo = vec4(1.0);
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (_600.instance_params.stride > 0)
    {
        vec4 inst_m0 = _610.instance_transform[(instanceID * uint(_600.instance_params.stride)) + 0u];
        vec4 inst_m1 = _610.instance_transform[(instanceID * uint(_600.instance_params.stride)) + 1u];
        vec4 inst_m2 = _610.instance_transform[(instanceID * uint(_600.instance_params.stride)) + 2u];
        vec3 _646 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _646.x;
        mat_instance_model[0].y = _646.y;
        mat_instance_model[0].z = _646.z;
        vec3 _659 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _659.x;
        mat_instance_model[1].y = _659.y;
        mat_instance_model[1].z = _659.z;
        vec3 _672 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _672.x;
        mat_instance_model[2].y = _672.y;
        mat_instance_model[2].z = _672.z;
        vec3 _686 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _686.x;
        mat_instance_model[3].y = _686.y;
        mat_instance_model[3].z = _686.z;
    }
    vec3 instance_function_origin = _156.raymarch_params.function_origin;
    if (_156.raymarch_params.use_instance_origin != 0)
    {
        instance_function_origin = (mat_instance_model * vec4(_156.raymarch_params.function_origin, 1.0)).xyz * 0.001000000047497451305389404296875;
    }
    mat_instance_model = _716.transform_params.mModel * mat_instance_model;
    mat4 mat_instance_model_inv = mat_instance_model;
    mat3 param = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
    mat3 inv = inverse_mat3(param);
    mat_instance_model_inv[0].x = inv[0].x;
    mat_instance_model_inv[0].y = inv[0].y;
    mat_instance_model_inv[0].z = inv[0].z;
    mat_instance_model_inv[1].x = inv[1].x;
    mat_instance_model_inv[1].y = inv[1].y;
    mat_instance_model_inv[1].z = inv[1].z;
    mat_instance_model_inv[2].x = inv[2].x;
    mat_instance_model_inv[2].y = inv[2].y;
    mat_instance_model_inv[2].z = inv[2].z;
    mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
    mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
    mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    vec3 ro = (mat_instance_model_inv * vec4(vtx_input.vWorldPos, 1.0)).xyz;
    vec3 rd = (mat_instance_model_inv * vec4(_716.transform_params.vCameraPosition, 1.0)).xyz;
    rd = normalize(ro - rd);
    ro *= _156.raymarch_params.function_scale;
    vec3 ro_bounding_volume = ro;
    ro += instance_function_origin;
    vec4 color = vec4(1.0);
    float bounding_volume_intersection = 100000.0;
    if (_156.raymarch_params.clamp_to_volume != 0)
    {
        vec3 param_1 = ro_bounding_volume;
        vec3 param_2 = rd;
        vec3 param_3 = _156.raymarch_params.function_scale;
        bounding_volume_intersection = raymarchBBox(param_1, param_2, param_3);
    }
    vec3 param_4 = ro;
    vec3 param_5 = rd;
    float param_6 = bounding_volume_intersection;
    vec4 param_7;
    float _887 = calcIntersection(param_4, param_5, param_6, param_7);
    color = param_7;
    float intersection = _887;
    if (intersection > 0.0)
    {
        vec3 ri = ro + (rd * intersection);
        ri -= instance_function_origin;
        ri /= _156.raymarch_params.function_scale;
        ri = ((_716.transform_params.mView * mat_instance_model) * vec4(ri, 1.0)).xyz;
        vec3 _923 = mix(vec3(1.0), color.xyz, vec3(_156.raymarch_params.param4));
        outAlbedo.x = _923.x;
        outAlbedo.y = _923.y;
        outAlbedo.z = _923.z;
        if (true)
        {
            float near = -1.0;
            float far = 1.0;
            float depth = (_716.transform_params.mProjection * vec4(ri, 1.0)).z / (_716.transform_params.mProjection * vec4(ri, 1.0)).w;
            depth = ((((far - near) * depth) + near) + far) / 2.0;
            gl_FragDepth = depth;
        }
    }
    else
    {
        if (_156.raymarch_params.show_bounding_box != 0)
        {
            if (intersection == (-1.0))
            {
                outAlbedo = vec4(0.4000000059604644775390625, 0.20000000298023223876953125, 0.0, 1.0);
            }
            else
            {
                outAlbedo = vec4(5.0, 0.0, 0.0, 1.0);
            }
            vec3 _988 = fract(vtx_input.vCoords * 0.00999999977648258209228515625);
            outAlbedo.x = _988.x;
            outAlbedo.y = _988.y;
            outAlbedo.z = _988.z;
        }
        else
        {
            discard;
        }
    }
}

 