#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct GTAOConstants
{
    float EffectRadius;
    float EffectFalloffRange;
    float RadiusMultiplier;
};

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _150;

layout(set = 0, binding = 2, std140) uniform GTAOGenerateDepthMipsParamsBuffer
{
    GTAOConstants gtao_params;
} _197;

layout(set = 0, binding = 8) uniform sampler2D sTextureDepth;
layout(set = 0, binding = 3, r32f) uniform writeonly image2D imOutputDepthMip0;
layout(set = 0, binding = 4, r32f) uniform writeonly image2D imOutputDepthMip1;
layout(set = 0, binding = 5, r32f) uniform writeonly image2D imOutputDepthMip2;
layout(set = 0, binding = 6, r32f) uniform writeonly image2D imOutputDepthMip3;
layout(set = 0, binding = 7, r32f) uniform writeonly image2D imOutputDepthMip4;

shared float g_scratchDepths[8][8];

float linearizeDepth(float d)
{
    return _150.dispatch_setup.near_far_plane.z / ((_150.dispatch_setup.near_far_plane.y + _150.dispatch_setup.near_far_plane.x) - (d * _150.dispatch_setup.near_far_plane.w));
}

float XeGTAO_ClampDepth(float depth)
{
    return clamp(depth, 0.0, 3.4028234663852885981170418348452e+38);
}

float saturate(float a)
{
    return max(0.0, min(1.0, a));
}

float XeGTAO_DepthMIPFilter(float depth0, float depth1, float depth2, float depth3, GTAOConstants consts)
{
    float maxDepth = max(max(depth0, depth1), max(depth2, depth3));
    float effectRadius = (0.75 * consts.EffectRadius) * consts.RadiusMultiplier;
    float falloffRange = consts.EffectFalloffRange * effectRadius;
    float falloffFrom = effectRadius * (1.0 - consts.EffectFalloffRange);
    float falloffMul = (-1.0) / falloffRange;
    float falloffAdd = (falloffFrom / falloffRange) + 1.0;
    float param = ((maxDepth - depth0) * falloffMul) + falloffAdd;
    float weight0 = saturate(param);
    float param_1 = ((maxDepth - depth1) * falloffMul) + falloffAdd;
    float weight1 = saturate(param_1);
    float param_2 = ((maxDepth - depth2) * falloffMul) + falloffAdd;
    float weight2 = saturate(param_2);
    float param_3 = ((maxDepth - depth3) * falloffMul) + falloffAdd;
    float weight3 = saturate(param_3);
    float weightSum = ((weight0 + weight1) + weight2) + weight3;
    return ((((weight0 * depth0) + (weight1 * depth1)) + (weight2 * depth2)) + (weight3 * depth3)) / weightSum;
}

void main()
{
    uvec2 workgroup_id = gl_WorkGroupID.xy;
    uvec2 local_thread_id = gl_LocalInvocationID.xy;
    uvec2 thread_id = (workgroup_id * uvec2(8u)) + local_thread_id;
    GTAOConstants _201;
    _201.EffectRadius = _197.gtao_params.EffectRadius;
    _201.EffectFalloffRange = _197.gtao_params.EffectFalloffRange;
    _201.RadiusMultiplier = _197.gtao_params.RadiusMultiplier;
    GTAOConstants consts = _201;
    uvec2 baseCoord = thread_id;
    uvec2 pixCoord = baseCoord * uvec2(2u);
    vec4 depths4 = textureGatherOffset(sTextureDepth, vec2(vec2(pixCoord) * _150.dispatch_setup.inv_resolution), ivec2(1));
    float param = depths4.w;
    float param_1 = linearizeDepth(param);
    float depth0 = XeGTAO_ClampDepth(param_1);
    float param_2 = depths4.z;
    float param_3 = linearizeDepth(param_2);
    float depth1 = XeGTAO_ClampDepth(param_3);
    float param_4 = depths4.x;
    float param_5 = linearizeDepth(param_4);
    float depth2 = XeGTAO_ClampDepth(param_5);
    float param_6 = depths4.y;
    float param_7 = linearizeDepth(param_6);
    float depth3 = XeGTAO_ClampDepth(param_7);
    imageStore(imOutputDepthMip0, ivec2(pixCoord + uvec2(0u)), vec4(depth0));
    imageStore(imOutputDepthMip0, ivec2(pixCoord + uvec2(1u, 0u)), vec4(depth1));
    imageStore(imOutputDepthMip0, ivec2(pixCoord + uvec2(0u, 1u)), vec4(depth2));
    imageStore(imOutputDepthMip0, ivec2(pixCoord + uvec2(1u)), vec4(depth3));
    float param_8 = depth0;
    float param_9 = depth1;
    float param_10 = depth2;
    float param_11 = depth3;
    float dm1 = XeGTAO_DepthMIPFilter(param_8, param_9, param_10, param_11, consts);
    imageStore(imOutputDepthMip1, ivec2(baseCoord), vec4(dm1));
    g_scratchDepths[local_thread_id.x][local_thread_id.y] = dm1;
    memoryBarrierShared();
    bool _321 = (local_thread_id.x % 2u) == 0u;
    bool _328;
    if (_321)
    {
        _328 = (local_thread_id.y % 2u) == 0u;
    }
    else
    {
        _328 = _321;
    }
    if (_328)
    {
        float inTL = g_scratchDepths[local_thread_id.x + 0u][local_thread_id.y + 0u];
        float inTR = g_scratchDepths[local_thread_id.x + 1u][local_thread_id.y + 0u];
        float inBL = g_scratchDepths[local_thread_id.x + 0u][local_thread_id.y + 1u];
        float inBR = g_scratchDepths[local_thread_id.x + 1u][local_thread_id.y + 1u];
        float param_12 = inTL;
        float param_13 = inTR;
        float param_14 = inBL;
        float param_15 = inBR;
        float dm2 = XeGTAO_DepthMIPFilter(param_12, param_13, param_14, param_15, consts);
        imageStore(imOutputDepthMip2, ivec2(baseCoord / uvec2(2u)), vec4(dm2));
        g_scratchDepths[local_thread_id.x][local_thread_id.y] = dm2;
    }
    memoryBarrierShared();
    bool _396 = (local_thread_id.x % 4u) == 0u;
    bool _403;
    if (_396)
    {
        _403 = (local_thread_id.y % 4u) == 0u;
    }
    else
    {
        _403 = _396;
    }
    if (_403)
    {
        float inTL_1 = g_scratchDepths[local_thread_id.x + 0u][local_thread_id.y + 0u];
        float inTR_1 = g_scratchDepths[local_thread_id.x + 2u][local_thread_id.y + 0u];
        float inBL_1 = g_scratchDepths[local_thread_id.x + 0u][local_thread_id.y + 2u];
        float inBR_1 = g_scratchDepths[local_thread_id.x + 2u][local_thread_id.y + 2u];
        float param_16 = inTL_1;
        float param_17 = inTR_1;
        float param_18 = inBL_1;
        float param_19 = inBR_1;
        float dm3 = XeGTAO_DepthMIPFilter(param_16, param_17, param_18, param_19, consts);
        imageStore(imOutputDepthMip3, ivec2(baseCoord / uvec2(4u)), vec4(dm3));
        g_scratchDepths[local_thread_id.x][local_thread_id.y] = dm3;
    }
    memoryBarrierShared();
    bool _470 = (local_thread_id.x % 8u) == 0u;
    bool _477;
    if (_470)
    {
        _477 = (local_thread_id.y % 8u) == 0u;
    }
    else
    {
        _477 = _470;
    }
    if (_477)
    {
        float inTL_2 = g_scratchDepths[local_thread_id.x + 0u][local_thread_id.y + 0u];
        float inTR_2 = g_scratchDepths[local_thread_id.x + 4u][local_thread_id.y + 0u];
        float inBL_2 = g_scratchDepths[local_thread_id.x + 0u][local_thread_id.y + 4u];
        float inBR_2 = g_scratchDepths[local_thread_id.x + 4u][local_thread_id.y + 4u];
        float param_20 = inTL_2;
        float param_21 = inTR_2;
        float param_22 = inBL_2;
        float param_23 = inBR_2;
        float dm4 = XeGTAO_DepthMIPFilter(param_20, param_21, param_22, param_23, consts);
        imageStore(imOutputDepthMip4, ivec2(baseCoord / uvec2(8u)), vec4(dm4));
    }
}

 