#version 450
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct DispatchParams
{
    mat4 mat_projection;
    mat4 mat_model;
    mat4 mat_model_previous;
    mat4 mat_view_inverse;
    mat4 mat_view_previous;
    vec3 camera_position;
    vec4 camera_projection_params;
    vec4 near_far_plane;
    vec2 resolution;
    vec2 inv_resolution;
};

struct GTAOParams
{
    float radius_multiplier;
    float _pad0;
    float _pad1;
    float _pad2;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std140) uniform DeferredParams
{
    layout(row_major) DispatchParams dispatch_setup;
} _123;

layout(set = 0, binding = 2, std140) uniform GTAOParamsBuffer
{
    GTAOParams gtao_params;
} _313;

layout(set = 0, binding = 3, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _361;

layout(set = 0, binding = 5) uniform sampler2D sTextureDepthPyramid;
layout(set = 0, binding = 6) uniform usampler2D sNormalMaterial;
layout(set = 0, binding = 4, r16f) uniform writeonly image2D imTarget;
layout(set = 0, binding = 7) uniform sampler2DArray s_BlueNoise;

vec2 unpackSnorm2x15(uint d)
{
    return (vec2(uvec2(d, d >> uint(15)) & uvec2(32767u)) / vec2(16383.5)) - vec2(1.0);
}

vec3 decode_normal(uint data)
{
    uint param = data;
    vec2 v = unpackSnorm2x15(param);
    uint s = data & 1073741824u;
    vec3 n;
    n.x = v.x;
    n.y = v.y;
    n.z = sqrt(clamp(1.0 - dot(n.xy, n.xy), 0.0, 1.0)) * ((s > 0u) ? 1.0 : (-1.0));
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

vec4 GetViewPosition(vec2 pos, float currstep)
{
    int miplevel = clamp(int(floor(log2(currstep / 8.0))), 0, 4);
    vec2 mipcoord = (pos + vec2(0.5)) * _123.dispatch_setup.inv_resolution;
    float d = textureLod(sTextureDepthPyramid, mipcoord, float(miplevel)).x;
    vec3 view_direction;
    view_direction.x = (-_123.dispatch_setup.camera_projection_params.z) + ((_123.dispatch_setup.camera_projection_params.x * pos.x) * _123.dispatch_setup.inv_resolution.x);
    view_direction.y = (-_123.dispatch_setup.camera_projection_params.w) + ((_123.dispatch_setup.camera_projection_params.y * pos.y) * _123.dispatch_setup.inv_resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return vec4(view_direction * d, 1.0);
}

bool validate_sample_pos(vec2 p)
{
    bool _196 = p.x >= 0.0;
    bool _202;
    if (_196)
    {
        _202 = p.y >= 0.0;
    }
    else
    {
        _202 = _196;
    }
    bool _211;
    if (_202)
    {
        _211 = p.x < _123.dispatch_setup.resolution.x;
    }
    else
    {
        _211 = _202;
    }
    bool _219;
    if (_211)
    {
        _219 = p.y < _123.dispatch_setup.resolution.y;
    }
    else
    {
        _219 = _211;
    }
    if (_219)
    {
        return true;
    }
    return false;
}

float Falloff(float dist2, float _cosh)
{
    return 2.0 * clamp((dist2 - 0.01600000075995922088623046875) / 9.98400020599365234375, 0.0, 1.0);
}

void main()
{
    uvec2 workgroup_id = gl_WorkGroupID.xy;
    uvec2 local_thread_id = gl_LocalInvocationID.xy;
    uvec2 thread_id = (workgroup_id * uvec2(8u)) + local_thread_id;
    ivec2 loc = ivec2(thread_id);
    uint encoded_normal_material = texelFetch(sNormalMaterial, ivec2(thread_id), 0).x;
    uint param = encoded_normal_material;
    vec3 normal = decode_normal(param);
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    bool is_background = (materialId & 1) == 1;
    vec3 local_normal;
    local_normal.x = dot(normal, _123.dispatch_setup.mat_model[0].xyz);
    local_normal.y = dot(normal, _123.dispatch_setup.mat_model[1].xyz);
    local_normal.z = dot(normal, _123.dispatch_setup.mat_model[2].xyz);
    normal = local_normal;
    if (is_background)
    {
        imageStore(imTarget, ivec2(thread_id), vec4(1.0));
        return;
    }
    float d_scale = 1.0 / (1.0 + _313.gtao_params.radius_multiplier);
    vec2 param_2 = vec2(loc);
    float param_3 = 1.0;
    vec4 vpos = GetViewPosition(param_2, param_3);
    if (is_background)
    {
        imageStore(imTarget, ivec2(thread_id), vec4(0.0));
        return;
    }
    vec3 vnorm = normal;
    vec3 vdir = normalize(-vpos.xyz);
    vec2 noises = fract(texelFetch(s_BlueNoise, ivec3(ivec2(thread_id & uvec2(127u)), 0), 0).xy + vec2(float(_361.globals.monotonic & 1023) * 1.61803400516510009765625));
    noises.x = (noises.x * 2.0) - 1.0;
    float radius = (2.0 * _123.dispatch_setup.near_far_plane.y) / (vpos.z * d_scale);
    radius = max(radius, 8.0);
    radius = min(radius, 512.0);
    float stepsize = radius / 8.0;
    float ao = 0.0;
    vec4 s;
    vec3 ws;
    float dist2;
    float invdist;
    float ch;
    float falloff;
    for (int split = 0; split < 3; split++)
    {
        vec2 horizons = vec2(-1.0);
        float phi = (noises.x + (float(split) * 0.3333333432674407958984375)) * 3.1415927410125732421875;
        float division = noises.y * stepsize;
        float currstep = 1.0 + division;
        vec3 dir = vec3(cos(phi), sin(phi), 0.0);
        for (int j = 0; j < 8; j++)
        {
            vec2 offset_dir = vec2(dir.x, -dir.y);
            vec2 offset = round(offset_dir * currstep);
            ivec2 ioffset = ivec2(round(offset_dir * currstep));
            vec2 param_4 = vec2(thread_id) + offset;
            if (validate_sample_pos(param_4))
            {
                vec2 param_5 = vec2(thread_id) + offset;
                float param_6 = currstep;
                s = GetViewPosition(param_5, param_6);
                ws = s.xyz - vpos.xyz;
                ws *= d_scale;
                dist2 = dot(ws, ws);
                invdist = inversesqrt(dist2);
                ch = invdist * dot(ws, vdir);
                float param_7 = dist2;
                float param_8 = ch;
                falloff = Falloff(param_7, param_8);
                horizons.x = max(horizons.x, ch - falloff);
            }
            vec2 param_9 = vec2(thread_id) - offset;
            if (validate_sample_pos(param_9))
            {
                vec2 param_10 = vec2(thread_id) - offset;
                float param_11 = currstep;
                s = GetViewPosition(param_10, param_11);
                ws = s.xyz - vpos.xyz;
                ws *= d_scale;
                dist2 = dot(ws, ws);
                invdist = inversesqrt(dist2);
                ch = invdist * dot(ws, vdir);
                float param_12 = dist2;
                float param_13 = ch;
                falloff = Falloff(param_12, param_13);
                horizons.y = max(horizons.y, ch - falloff);
            }
            currstep += stepsize;
        }
        horizons = acos(horizons);
        vec3 bitangent = normalize(cross(dir, vdir));
        vec3 tangent = cross(vdir, bitangent);
        vec3 nx = vnorm - (bitangent * dot(vnorm, bitangent));
        float nnx = length(nx);
        float invnnx = 1.0 / (nnx + 9.9999999747524270787835121154785e-07);
        float cosxi = dot(nx, tangent) * invnnx;
        float gamma = acos(cosxi) - 1.57079637050628662109375;
        float cosgamma = dot(nx, vdir) * invnnx;
        float singamma2 = (-2.0) * cosxi;
        horizons.x = gamma + max((-horizons.x) - gamma, -1.57079637050628662109375);
        horizons.y = gamma + min(horizons.y - gamma, 1.57079637050628662109375);
        ao += (nnx * ((((horizons.x * singamma2) + cosgamma) - cos((2.0 * horizons.x) - gamma)) + (((horizons.y * singamma2) + cosgamma) - cos((2.0 * horizons.y) - gamma))));
    }
    ao *= 0.25;
    ao /= 3.0;
    imageStore(imTarget, ivec2(thread_id), vec4(max(0.0, ao)));
}

 