#version 450

struct TexGenCustomParams
{
    vec2 resolution;
    vec2 resolutionInv;
    float param1;
    float param2;
    float _pad0;
    float _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std140) uniform TexGenCustomParamsBuffer
{
    TexGenCustomParams params;
} _14;

layout(location = 0) in vec2 vTexcoord0;
layout(location = 0) out vec4 outColor;

void main()
{
    float bias = (_14.params.param1 / 25.0) - 2.0;
    float density = _14.params.param2 / 10.0;
    vec4 base_color = vec4(1.0, 0.0, 0.5, 1.0);
    vec2 d = vTexcoord0 - vec2(0.5);
    d.x *= (_14.params.resolution.x / _14.params.resolution.y);
    float r = d.x + d.y;
    float v = 0.0;
    r *= density;
    v = r;
    v = floor(v * 16.0) / 16.0;
    v -= bias;
    v = clamp(v, 0.0, 1.0);
    outColor = vec4(v);
}

 