#version 450
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleLifecycleParams
{
    float time_step;
    float max_lifetime;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint _pad1;
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _43;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    vec4 prt_positions[];
} _63;

layout(set = 0, binding = 3, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _115;

vec3 prt_get_position(uint id)
{
    return _63.prt_positions[id].xyz;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _51;
    _51.life_time = _43.prt_states[id].life_time;
    _51.life_span = _43.prt_states[id].life_span;
    _51.generation_id = _43.prt_states[id].generation_id;
    _51.color = _43.prt_states[id].color;
    ParticleState _50 = _51;
    return _50;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _58;
    _58.life_time = state.life_time;
    _58.life_span = state.life_span;
    _58.generation_id = state.generation_id;
    _58.color = state.color;
    _43.prt_states[id] = _58;
}

void prt_set_position(uint id, vec3 p)
{
    _63.prt_positions[id].x = p.x;
    _63.prt_positions[id].y = p.y;
    _63.prt_positions[id].z = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    ParticleState param_2 = p.state;
    float param_3 = _115.lifecycle_params.time_step;
    float param_4 = _115.lifecycle_params.max_lifetime;
    prt_advance_life(param_2, param_3, param_4);
    p.state = param_2;
    uint param_5 = id;
    ParticleState param_6 = p.state;
    prt_set_state(param_5, param_6);
    uint param_7 = id;
    vec3 param_8 = p.pos;
    prt_set_position(param_7, param_8);
}

 