'use strict'

entityRegistry['module']['clear'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'clearColor', displayName: 'Clear Color', type: 'boolean', defaultValue: false},
        { paramName: 'colorTransparent', displayName: 'Color Transparent', type: 'boolean', defaultValue: true},
        { paramName: 'colorValue', displayName: 'Color Value', type: 'color', defaultValue: [1, 0, 0]},
        { paramName: 'clearBrightness', displayName: 'Clear Brightness', type: 'boolean', defaultValue: false},
        { paramName: 'brightnessValue', displayName: 'Brightness Value', type: 'float', defaultValue: 0},
        { paramName: 'clearDepth', displayName: 'Clear Depth', type: 'boolean', defaultValue: false},
        { paramName: 'depthValue', displayName: 'Depth Value', type: 'float', defaultValue: 1000},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                clearColor,
                colorTransparent,
                colorValue,
                clearBrightness,
                brightnessValue,
                clearDepth,
                depthValue,
            } = { ...config }
            
            if (clearColor) {
                const colorBuffer = renderer.getCurrentBuffer('color')
                const colorId = colorTransparent ? 0 : renderer.getPaletteId([0, 0, 0], colorValue)
                for (let i = 0; i < colorBuffer.pixelCount; ++i) {
                    colorBuffer.data[i] = colorId
                }
            }

            if (clearBrightness) {
                const brightnessBuffer = renderer.getCurrentBuffer('brightness')
                for (let i = 0; i < brightnessBuffer.pixelCount; ++i) {
                    brightnessBuffer.data[i] = brightnessValue
                }
            }

            if (clearDepth) {
                const depthBuffer = renderer.getCurrentBuffer('depth')
                for (let i = 0; i < depthBuffer.pixelCount; ++i) {
                    depthBuffer.data[i] = depthValue
                }
            }
        }
    }
}
