'use strict'

entityRegistry['module']['progressCircle'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'maxDist', displayName: 'Max Dist', type: 'float', defaultValue: 100},
        { paramName: 'minDist', displayName: 'Min Dist', type: 'float', defaultValue: 50},
        { paramName: 'progress', displayName: 'Progress', type: 'float', defaultValue: 0},
        { paramName: 'steps', displayName: 'Steps', type: 'int', defaultValue: 16},
        { paramName: 'color', displayName: 'Color', type: 'color', defaultValue: [1, 0, 0]},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                maxDist,
                minDist,
                progress,
                steps,
                color,
            } = { ...config }

            const colorBuffer = renderer.getCurrentBuffer('color')
            // const brightnessBuffer = renderer.getCurrentBuffer('brightness')
            const colorId = renderer.getPaletteId([0, 0, 0], color, [0, 0, 0])
            const steppedProgress =  Math.floor(progress * steps) / steps
            const progressAngle = (steppedProgress - .5) * Math.PI*2

            const xOff = colorBuffer.width / 2
            const yOff = colorBuffer.height / 2

            let writeIndex = 0
            for (let y = 0; y < colorBuffer.height; ++y) {
                const sy = y - yOff
                for (let x = 0; x < colorBuffer.width; ++x) {
                    const sx = x - xOff
                    const dist = Math.sqrt(sx*sx + sy*sy)
                    if (dist < maxDist && dist > minDist) {
                        const angle = Math.atan2(-sx, sy)
                        if (angle<progressAngle) {
                            if (colorBuffer.data[writeIndex] === 0) {
                                colorBuffer.data[writeIndex] = colorId
                            } else {
                                colorBuffer.data[writeIndex]++
                            }
                        }
                    }
                    writeIndex++
                }
            }
        }
    }
}
