'use strict'

entityRegistry['module']['threeDeeMetaBoxTwo'] = {
    init: () => {
        return {
        }
    },
    staticConfig: [
    ],
    dynamicConfig: [
        { paramName: 'scale', displayName: 'Scale', type: 'float', defaultValue: 1},
        { paramName: 'animation', displayName: 'Animation', type: 'float', defaultValue: 0},
        { paramName: 'ballSize', displayName: 'Ball Size', type: 'float', defaultValue: 1},
        { paramName: 'blendFactor', displayName: 'Blend Factor', type: 'float', defaultValue: 20},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            function getIso1 (p, mat1, mat2, mat3, ballSize, blendFactor) {

                const iso1 = opTransform(p, mat1, (p) => getIsoSphere(p, ballSize))
                const iso2 = opTransform(p, mat2, (p) => getIsoSphere(p, ballSize))
                const iso3 = opTransform(p, mat3, (p) => getIsoSphere(p, ballSize))
                const iso4 = getIsoBox(p, [10.0, 10.0, 10.0])
                return Math.max(iso4, sminCubic(iso1, sminCubic(iso2, iso3, blendFactor), blendFactor))
            }
            
            function sminCubic (a, b, k)
            {
                const h = Math.max( k-Math.abs(a-b), 0.0 )/k
                return Math.min( a, b ) - h*h*h*k*(1.0/6.0)
            }

            const {
                animation,
                scale,
                ballSize,
                blendFactor,
            } = { ...config }
            
            const fieldStrength = 0.1

            const sDist = 8 //- t*2
            const t = animation
            const mat1 = m4.translation(Math.sin((t+2.32)*1.12) * sDist, Math.sin((t+1.18)*1.97) * sDist, Math.sin((t+4.75)*1.01) * sDist)
            const mat2 = m4.translation(Math.sin((t+1.59)*1.88) * sDist, Math.sin((t+5.11)*2.35) * sDist, Math.sin((t+0.23)*2.18) * sDist)
            const mat3 = m4.translation(Math.sin((t+3.23)*1.32) * sDist, Math.sin((t+9.31)*1.21) * sDist, Math.sin((t+9.13)*2.53) * sDist)
    
            const fieldSize = 12
            const isoField = makeIsoField(fieldSize, (x, y, z) => getIso1([x, y, z], mat1, mat2, mat3, ballSize, blendFactor))
            const lists = renderIsoField(fieldSize, isoField, fieldStrength)

            const model = {
                verts: lists.verts,
                objects: [
                    {
                        name: 'balls',
                        subObjects: [
                            {
                                diffuse: [.4, .5, .6],
                                ambient: [1, 0, 0],
                                emissive: [0.05, 0.1, 0.2],
                                lines: [],
                                tris: lists.tris,
                                quads: [],
                            }
                        ]
                    }
                ]
            }

            const scaleMat = m4.scaling(scale, scale, scale)
            const colorBuffer = renderer.getCurrentBuffer('color')
            const depthBuffer = renderer.getCurrentBuffer('depth')
            const brightnessBuffer = renderer.getCurrentBuffer('brightness')
            renderer.decorateModel(model)
            renderer.drawModel(model, scaleMat, colorBuffer, depthBuffer, brightnessBuffer)
       }
    }
}
